<?php

namespace App\Models;

use App\Casts\Json;
use App\Http\Traits\hasFilter;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShopCategory extends Model
{
    use HasFactory, SoftDeletes, hasFilter;

    protected $table    =   'shop_categories';
    protected $guarded  =   ['id'];
    protected $dates  =   ['valid_from', 'valid_to'];
    protected $casts    =   ['current_status_json' => Json::class];
    protected $appends = ['days_left'];

    public function shop() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function category() {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function payment() {
        return $this->belongsTo(PaymentTransaction::class, 'payment_id', 'id');
    }

    public function package() {
        return $this->belongsTo(Package::class, 'package_id', 'id')->withTrashed();
    }

    public function getDaysLeftAttribute()
    {
        if ($this->valid_to->diffInDays($this->valid_from) <= 0) {
            return 0;
        }
        return $this->valid_to->diffInDays($this->valid_from);
    }

    public function IsActiveScope($query) {
        $query->where('is_active', 1);
    }
}
