<?php

namespace App\Models;

use App\Http\Traits\hasFilter;
use App\Http\Traits\HashIdTrait;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens,HasFactory, Notifiable, HashIdTrait,SoftDeletes, hasFilter, HasRoles;

    protected $table    =   'users';
    protected $guarded  =   ['id'];
    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'phone_verified_at' => 'datetime',
    ];
    protected static function booted()
    {
        static::creating(function ($user) {
            $user->user_vendor = request()->get('user_type')==2?true:false;
        });
    }
    protected $appends = ['phone_with_code', 'default_image', 'display_shop_name'];

    protected $with =   ['country'];

    public function sms() {
        return $this->hasMany(SMSLog::class, 'user_id', 'id');
    }
    public function country() {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }

    public function products() {
        return $this->hasMany(Product::class, 'user_id', 'id');
    }
    public function transactions() {
        return $this->hasMany(PaymentTransaction::class, 'user_id', 'id');
    }

    public function profileImage() {
        return $this->morphOne(Image::class,'imageable');
    }

//    public function setPasswordAttribute($value) {
//        return $this->attributes['password'] = Hash::make($value);
//    }

    public function favorite() {
        return $this->morphMany(Favorite::class, 'favoriteable');
    }

    public function getDefaultImageAttribute() {
        $image = optional($this->profileImage()->where('is_default', 1)->first())->path;
        return $this->attributes['default_image'] = $image? asset('storage/'.$image) : ($this->user_type == 1 ? asset('dashboard/images/logo/user.jpg') : asset('dashboard/images/logo/shop.png'));
    }

    public function categories() {
        return $this->hasMany(ShopCategory::class, 'user_id', 'id');
    }

    public function activeCategories() {
        return $this->categories()->where('is_active', 1);
    }

    public function activeProducts() {
        $categoryId = request()->input('category_id');
        return $this->products()
            ->where('is_active',1)
            ->where('is_approved',1)
            ->when(!is_null($categoryId), function ($query)use($categoryId){
                $query->where('category_id', $categoryId);
            });
    }

    public function getDisplayShopNameAttribute() {
        return $this->attributes['display_shop_name']   =
            is_null($this->shop_name_en) || app()->getLocale() == 'ar'
                ? $this->shop_name :
                $this->shop_name_en;
    }

    public function getPhoneWithCodeAttribute()
    {
        return $this->attributes['phone_with_code'] = optional($this->country)->code.$this->phone;
    }

    public function notificationData() {
        return [
            'image' =>  optional($this->profileImage)->full_path,
            'name'  =>  $this->name,
            'id'    =>  $this->id
        ];
    }
}

