<?php

namespace App\Providers;

use App\Repository\Base\BaseRepo;
use App\Repository\Base\BaseRepoInterface;
use App\Repository\Categories\CategoriesRepo;
use App\Repository\Categories\CategoriesRepoInterface;
use App\Repository\Countries\CountriesRepo;
use App\Repository\Countries\CountriesRepoInterface;
use App\Repository\Users\UsersRepo;
use App\Repository\Users\UsersRepoInterface;
use Illuminate\Support\ServiceProvider;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(BaseRepoInterface::class, BaseRepo::class);

        $this->app->bind(UsersRepoInterface::class, UsersRepo::class);

    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
