<?php


namespace App\Repository\Users;


use App\Enums\HttpCodesEnum;
use App\Enums\SMSEnums;
use App\Enums\UsersTypesEnums;
use App\Http\Services\SMSService;
use App\Http\Traits\UploadHandler;
use App\Models\User;
use App\Repository\Base\BaseRepo;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class UsersRepo extends BaseRepo implements UsersRepoInterface
{
    use UploadHandler;
    public function __construct(User $model)
    {
        parent::__construct($model);
    }

    public function create($attributes): Model
    {
        $filterKeys = collect($attributes)
            ->only('name', 'phone', 'shop_name', 'shop_name_en', 'whatsapp', 'whatsapp_country_id', 'whatsapp_country_code', 'country_id' ,'password', 'user_type', 'instagram', 'facebook', 'snapchat');
        $filterKeys->offsetSet("password", bcrypt($filterKeys->get("password")));
        $user = $this->model->create($filterKeys->toArray())->fresh();
        (new SMSService($user))->sendActivationCode($user);
        $this->uploadShopImage(request(), $user, 'image');
        return $user;
    }

    public function update(Request $request): Model
    {
        $request->user('sanctum')->update(
            ['name'  =>  $request->input('name')]
            + UpdateShopProfile($request)
            + UpdateUserPassword($request)
            + UpdateUserEmail($request)
        );

        $this->uploadShopImage($request, $request->user('sanctum'), 'image');

        return $request->user('sanctum')->fresh();
    }

    public function activeUserBySmsCode(Request $request) {
         $code_exists    =   $this->validateCode(SMSEnums::Activation);

        if($request->user('sanctum')->phone_verified_at) {
            return [trans('global.user_already_activated'), HttpCodesEnum::ValidationError];
        }

        if($code_exists) {
            $request->user('sanctum')->update(['phone_verified_at' => Carbon::now()]);
            $request->user('sanctum')->sms()->where('type', SMSEnums::Activation)->update(['code'=>null]);
            return [trans('global.user_activated_successfully'), HttpCodesEnum::Success];
        }
        return [trans('global.invalid_code_number'), HttpCodesEnum::ValidationError];
    }

    public function ChangePhoneBySmsCode(Request $request) {
        $code_exists    =   $this->validateCode(SMSEnums::Activation);
        //todo Validate the given number is already exists for others

        if($code_exists) {
            $request->user('sanctum')->update([
                'phone_verified_at'      =>  $request->input('phone_verified_at'),
                'country_id'    =>  $request->input('country_id'),
                'phone'         =>  $request->input('phone'),
            ]);
            $request->user('sanctum')->sms()->where('type', SMSEnums::Activation)->update(['code'=>null]);
            return [trans('global.user_activated_successfully'), HttpCodesEnum::Success];
        }
        return [trans('global.invalid_code_number'), HttpCodesEnum::ValidationError];
    }

    public function activeEmailByCode(Request $request) {
        $code_exists    =   $this->validateCode(SMSEnums::EmailActivation);

        if($request->user('sanctum')->email_verified_at) {
            return [trans('global.user_email_already_activated'), HttpCodesEnum::ValidationError];
        }

        if($code_exists) {
            $request->user('sanctum')->update(['email_verified_at' => Carbon::now()]);
            $request->user('sanctum')->sms()->where('type', SMSEnums::EmailActivation)->update(['code'=>null]);
            return [trans('global.user_email_activated_successfully'), HttpCodesEnum::Success];
        }
        return [trans('global.invalid_code_number'), HttpCodesEnum::ValidationError];
    }

    private function validateCode($type) {
        if(app()->isProduction())
            return \request()->user('sanctum')->sms()->where('type', $type)->where('code', \request()->input('code'))->exists();
        else
            return (\request()->input('code') == '1234' );
    }
}
