<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class CheckShopHaveValidSubscribeCategory implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $hasValidSubscribe = request()->user()->categories()
            ->where('is_active', 1)
            ->where('id', $value)
            ->first();

        return $hasValidSubscribe;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return trans('global.you_dont_have_valid_subscribe_in_this_category');
    }
}
