<?php

namespace Database\Seeders;

use App\Enums\SettingsEnum;
use App\Models\Package;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class FreeMonthSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Setting::updateOrCreate([
            'key'       =>  'FreeMonth'
        ],
        [
            'value'     =>  0,
            'is_shown'  =>  1,
            'type'      =>  SettingsEnum::StringType
        ]);
        Setting::updateOrCreate([
            'key'       =>  'FreePackageId'
        ],
        [
            'value'     =>  Package::first()->id,
            'is_shown'  =>  1,
            'type'      =>  SettingsEnum::StringType
        ]);
    }
}
