<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Package;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PackagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Package::query()->truncate();

        Package::query()->insert([
            [
                'ar_name'   =>  'شهر',
                'en_name'   =>  'Month',
                'cost'      =>  '250',
                'days'      =>  '30',
            ],
            [
                'ar_name'   =>  '3 شهور',
                'en_name'   =>  '3 Months',
                'cost'      =>  '500',
                'days'      =>  '90',
            ],
            [
                'ar_name'   =>  '6 شهور',
                'en_name'   =>  '6 Months',
                'cost'      =>  '750',
                'days'      =>  '180',
            ],
        ]);

        Category::all()->each(function ($cat){
            $cat->packages()->attach([1,2,3]);
        });
    }
}
