<?php

namespace Database\Seeders;

use App\Models\Admin;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        Role::query()->truncate();
        Permission::query()->truncate();

        Role::query()->insert([
            ['name' => 'super_admin' , 'ar_name'    =>  'مدير', 'guard_name' => 'admins'],
            ['name' => 'product_manager' , 'ar_name'    =>  'مدير منتجات', 'guard_name' => 'admins'],
            ['name' => 'reader', 'ar_name'  =>  'قارئ', 'guard_name' => 'admins']
        ]);

        Permission::query()->insert([
            ['name' => 'dashboard_cards', 'ar_name' => 'عدادات لوحة التحكم', 'group_name' => 'dashboard', 'guard_name' => 'admins'],

            ['name' => 'permissions_index', 'ar_name' => 'مشاهدة الصلاحيات', 'group_name' => 'permissions', 'guard_name' => 'admins'],
            ['name' => 'permissions_create', 'ar_name' => 'انشاء صلاحية جديده', 'group_name' => 'permissions', 'guard_name' => 'admins'],
            ['name' => 'permissions_edit', 'ar_name' => 'تعديل الصلاحيات', 'group_name' => 'permissions', 'guard_name' => 'admins'],
            ['name' => 'permissions_delete', 'ar_name' => 'حذف الصلاحيات', 'group_name' => 'permissions', 'guard_name' => 'admins'],

            ['name' => 'admins_index', 'ar_name' => 'مشاهدة المديرين', 'group_name' => 'admins', 'guard_name' => 'admins'],
            ['name' => 'admins_create', 'ar_name' => 'انشاء مدير جديد', 'group_name' => 'admins', 'guard_name' => 'admins'],
            ['name' => 'admins_edit', 'ar_name' => 'تعديل المديرين', 'group_name' => 'admins', 'guard_name' => 'admins'],
            ['name' => 'admins_delete', 'ar_name' => 'حذف المديرين', 'group_name' => 'admins', 'guard_name' => 'admins'],

            ['name' => 'countries_index', 'ar_name' => 'مشاهدة الدول', 'group_name' => 'countries', 'guard_name' => 'admins'],
            ['name' => 'countries_create', 'ar_name' => 'انشاء دولة جديدة', 'group_name' => 'countries', 'guard_name' => 'admins'],
            ['name' => 'countries_edit', 'ar_name' => 'تعديل الدول', 'group_name' => 'countries', 'guard_name' => 'admins'],

            ['name' => 'categories_index', 'ar_name' => 'مشاهدة الاقسام', 'group_name' => 'categories', 'guard_name' => 'admins'],
            ['name' => 'categories_create', 'ar_name' => 'انشاء الاقسام', 'group_name' => 'categories', 'guard_name' => 'admins'],
            ['name' => 'categories_edit', 'ar_name' => 'تعديل الاقسام', 'group_name' => 'categories', 'guard_name' => 'admins'],
            ['name' => 'categories_arrange', 'ar_name' => 'ترتيب الاقسام', 'group_name' => 'categories', 'guard_name' => 'admins'],

            ['name' => 'packages_index', 'ar_name' => 'مشاهدة الباقات', 'group_name' => 'packages', 'guard_name' => 'admins'],
            ['name' => 'packages_create', 'ar_name' => 'انشاء باقات', 'group_name' => 'packages', 'guard_name' => 'admins'],
            ['name' => 'packages_edit', 'ar_name' => 'تعديل الباقات', 'group_name' => 'packages', 'guard_name' => 'admins'],

            ['name' => 'users_index', 'ar_name' => 'مشاهدة المستخدمين', 'group_name' => 'users', 'guard_name' => 'admins'],
            ['name' => 'users_create', 'ar_name' => 'انشاء مستخدمين', 'group_name' => 'users', 'guard_name' => 'admins'],
            ['name' => 'users_edit', 'ar_name' => 'تعديل مستخدمين', 'group_name' => 'users', 'guard_name' => 'admins'],
            ['name' => 'users_delete', 'ar_name' => 'حذف المستخدمين', 'group_name' => 'users', 'guard_name' => 'admins'],

            ['name' => 'shops_index', 'ar_name' => 'مشاهدة المتاجر', 'group_name' => 'shops', 'guard_name' => 'admins'],
            ['name' => 'shops_create', 'ar_name' => 'انشاء متاجر', 'group_name' => 'shops', 'guard_name' => 'admins'],
            ['name' => 'shops_edit', 'ar_name' => 'تعديل المتاجر', 'group_name' => 'shops', 'guard_name' => 'admins'],
            ['name' => 'shops_delete', 'ar_name' => 'حذف المتاجر', 'group_name' => 'shops', 'guard_name' => 'admins'],
            ['name' => 'shops_notification', 'ar_name' => 'ارسال شعار باستخدم المتجر', 'group_name' => 'shops', 'guard_name' => 'admins'],

            ['name' => 'products_index', 'ar_name' => 'مشاهدة المنتجات', 'group_name' => 'products', 'guard_name' => 'admins'],
            ['name' => 'products_create', 'ar_name' => 'انشاء منتجات', 'group_name' => 'products', 'guard_name' => 'admins'],
            ['name' => 'products_edit', 'ar_name' => 'تعديل المنتجات', 'group_name' => 'products', 'guard_name' => 'admins'],
            ['name' => 'products_delete', 'ar_name' => 'حذف المنتجات', 'group_name' => 'products', 'guard_name' => 'admins'],
            ['name' => 'products_notification', 'ar_name' => 'ارسال اشعار باستخدام المنتج', 'group_name' => 'products', 'guard_name' => 'admins'],
            ['name' => 'products_approval', 'ar_name' => 'الموافقة علي ظهور المنتج', 'group_name' => 'products', 'guard_name' => 'admins'],

            ['name' => 'subscriptions_index', 'ar_name' => 'مشاهدة الاشتراكات', 'group_name' => 'subscriptions', 'guard_name' => 'admins'],
            ['name' => 'payment_transactions_index', 'ar_name' => 'مشاهدة العمليات المالية', 'group_name' => 'payment_transactions', 'guard_name' => 'admins'],

            ['name' => 'complaints_index', 'ar_name' => 'مشاهدة الشكاوي', 'group_name' => 'complaints_transactions', 'guard_name' => 'admins'],

            ['name' => 'notifications_index', 'ar_name' => 'ارسال اشعارات', 'group_name' => 'notifications_transactions', 'guard_name' => 'admins'],

            ['name' => 'settings_index', 'ar_name' => 'تعديل الاعدادت', 'group_name' => 'settings_transactions', 'guard_name' => 'admins'],

            ['name' => 'marketers_index', 'ar_name' => 'مشاهدة المستخدمين', 'group_name' => 'marketers', 'guard_name' => 'admins'],
            ['name' => 'marketers_create', 'ar_name' => 'انشاء مستخدمين', 'group_name' => 'marketers', 'guard_name' => 'admins'],
            ['name' => 'marketers_edit', 'ar_name' => 'تعديل مستخدمين', 'group_name' => 'marketers', 'guard_name' => 'admins'],
            ['name' => 'marketers_delete', 'ar_name' => 'حذف المستخدمين', 'group_name' => 'marketers', 'guard_name' => 'admins'],
        ]);

        $role = Role::query()->where('name' , 'super_admin')->first();
        $role->syncPermissions(Permission::query()->get());
        Admin::query()->first()->assignRole('super_admin');

        Schema::enableForeignKeyConstraints();
    }
}
