<?php

namespace Database\Seeders;

use App\Enums\SettingsEnum;
use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Setting::query()->truncate();

        Setting::query()->insert([
            [
                'key'       =>  'VendorContract',
                'value'     =>  json_encode(['ar'=>'بيانات العقد', 'en'=>'contractData'],true),
                'is_shown'  =>  1,
                'type'      =>  SettingsEnum::JsonType
            ],
            [
                'key'       =>  'TotalPayment',
                'value'     =>  0,
                'is_shown'  =>  0,
                'type'      =>  SettingsEnum::StringType
            ],
            [
                'key'       =>  'PrivacyPolicy',
                'value'     =>  json_encode(['ar'=>'بيانات الخصوصية', 'en'=>'privacy policy'],true),
                'is_shown'  =>  1,
                'type'      =>  SettingsEnum::JsonType
            ],
        ]);
    }
}
