<?php

namespace Database\Seeders;

use App\Models\ShopCategory;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class ShopCategoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        ShopCategory::query()->truncate();

        ShopCategory::query()->insert([
            [
                'user_id'       =>  2,
                'category_id'   =>  1,
                'payment_id'    =>  1,
                'package_id'    =>  1,
                'is_active'     =>  1,
                'product_count' =>  10,
                'valid_from'    =>  Carbon::now(),
                'valid_to'      =>  Carbon::now()->addMonth(),
                'current_status_json'          =>  json_encode(['test'], true),
            ]
        ]);
    }
}
