<?php

namespace Database\Seeders;

use App\Enums\UsersTypesEnums;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        User::query()->truncate();

        User::query()->insert([
            [
                'user_type'         =>  UsersTypesEnums::User,
                'name'              =>  'Normal User',
                'country_id'        =>  1,
                'phone'             =>  '50723346',
                'shop_name'         =>  'Mango',
                'email'             =>  null,
                'whatsapp'          =>  '+97450723346',
                'instagram'         =>  'https://www.instagram.com/Mango',
                'password'          =>  Hash::make('6543210'),
                'phone_verified_at' =>  Carbon::now(),
                'shop_accept_contract' =>  0,
            ],
            [
                'user_type'         =>  UsersTypesEnums::Vendor,
                'name'              =>  'Vendor User',
                'country_id'        =>  1,
                'phone'             =>  '70138435',
                'shop_name'         =>  'Zara',
                'email'             =>  null,
                'whatsapp'          =>  '+97470138435',
                'instagram'         =>  'https://www.instagram.com/Zara',
                'password'          =>  Hash::make('6543210'),
                'phone_verified_at' =>  Carbon::now(),
                'shop_accept_contract' =>  1,
            ],
        ]);
    }
}
