@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.admins')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('admins.index') }}">@lang('sidebar.admins')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.edit')
            </li>
        </ol>
    </div>
@endsection
@section('content')

    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="{{ route('admins.update', $admin->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="form-body">
                                    <div class="col-12 text-center mb-1">
                                        <input type="file" style="display: none" name="image" id="defaultImageInput">
                                        <img src="{{ $admin->logo }}" class="img-fluid mb-1 rounded-sm defaultImage" style="width: 100px" alt="user_image">
                                        <br>
                                        <button type="button" class="btn btn-primary btn-sm setDefaultImage">@lang('global.change_user_image')</button>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.name')</label>
                                                    <input autocomplete="off" type="text" class="form-control" name="name" placeholder="@lang('global.name')" value="{{ old('name', $admin->name) }}" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <label for="users-list-status">@lang('global.password')</label>
                                            <fieldset class="form-group">
                                                <input class="form-control" type="password" name="password" placeholder="@lang('global.password')"  pattern=".{6,}" autocomplete="off">
                                            </fieldset>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <label for="users-list-status">@lang('global.password_confirmation')</label>
                                            <fieldset class="form-group">
                                                <input class="form-control" type="password" placeholder="@lang('global.password_confirmation')" name="password_confirmation" pattern=".{6,}" autocomplete="off">
                                            </fieldset>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <fieldset class="form-group position-relative input-divider-right">
                                                <label>@lang('global.phone_admin')</label>
                                                <input type="text"
                                                       class="form-control"
                                                       name="phone"
                                                       placeholder="@lang('global.phone_pattern')"
                                                       value="{{ old('phone', $admin->phone) }}"
                                                       autocomplete="off"
                                                       required="">
                                            </fieldset>
                                        </div>
                                        @if (Auth::user()->hasRole(['super_admin']))

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.active')</label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                        <option value="" {{ is_null(old('is_active', $admin->is_active)) == 1 ? "selected" : "" }}>@lang('global.select_is_active')</option>
                                                        <option value="1" {{ old('is_active', $admin->is_active) == 1 ? "selected" : "" }}>@lang('global.active')</option>
                                                        <option value="0" {{ !is_null(old('is_active', $admin->is_active)) && old('is_active', $admin->is_active) == 0 ? "selected" : "" }}>@lang('global.not_active')</option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.roles')</label>
                                                    <select class="form-control" name="role_id" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                        @foreach($roles as $role)
                                                            <option value="{{ $role->id }}" {{ old('role_id', $current_role) == $role->id ? "selected" : "" }}>{{ getRoleName($role) }}</option>
                                                        @endforeach
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif


                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="{{ route('admins.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('scripts')
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('.defaultImage').attr('src', e.target.result);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#defaultImageInput").change(function() {
            readURL(this);
        });

        $('.setDefaultImage').on('click', function (evt) {
            evt.preventDefault();
            $("#defaultImageInput").click();
        })
    </script>
@endpush
