@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.admins')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('admins.index') }}">@lang('sidebar.admins')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">@lang('global.filters')</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="#">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-role">@lang('global.name')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="{{ request()->input('name') }}" autocomplete="off">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-status">@lang('global.phone_admin')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="phone" value="{{ request()->input('phone') }}" autocomplete="off" type="number">
                                    </fieldset>
                                </div>

                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-status">@lang('global.is_active')</label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active">
                                            <option value="">@lang('global.select_is_active')</option>
                                            <option value="1" {{ request()->input('is_active') == 1 ? 'selected' : '' }}>@lang('global.active')</option>
                                            <option value="0" {{ !is_null(request()->input('is_active')) && request()->input('is_active') == 0 ? 'selected' : '' }}>@lang('global.not_active')</option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> @lang('global.search')</button>
                                <a href="{{ route('admins.index') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    @lang('global.clear_search')
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            @can('admins_create')
                                                <div class="col-2 text-right">
                                                    <a href="{{ route('admins.create') }}" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            @endcan
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.image')</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.phone_admin')</th>
                                                        <th>@lang('global.is_active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @forelse($admins as $admin)
                                                        <tr class="text-center">
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>
                                                                <div class="pr-1">
                                                                        <span class="avatar m-0 avatar-md"><img class="media-object rounded-circle" src="{{ $admin->logo }}" height="42" width="42" alt="Generic placeholder image">
                                                                            <i></i>
                                                                        </span>
                                                                </div>
                                                            </td>
                                                            <td>{{ $admin->name }}</td>

                                                            <td>{{ $admin->phone }}</td>
                                                            <td>{!! isActiveHtml($admin->is_active) !!}</td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    @can('admins_edit')
                                                                        <a href="{{ route('admins.edit', HashIdObj()->encode($admin->id)) }}" title="@lang('global.edit')" class="btn btn-primary btn-sm ml-1"><i class="fa fa-edit"></i></a>
                                                                        @if($admin->is_active)
                                                                            <a href="#" title="@lang('global.deactivate')" data-id="{{ $admin->id }}" data-route="{{ route('toggleAdminStatus') }}" data-message="@lang('global.deactivate_admin')" data-alt-msg="@lang('global.activate_admin')" class="btn btn-dark ml-1 btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                        @else
                                                                            <a href="#" title="@lang('global.activate')" data-id="{{ $admin->id }}" data-route="{{ route('toggleAdminStatus') }}" data-message="@lang('global.activate_admin')" data-alt-msg="@lang('global.deactivate_admin')" class="btn btn-success ml-1 btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                        @endif
                                                                    @endcan
                                                                    @can('admins_delete')
                                                                        <form action="{{ route('admins.destroy', $admin->id) }}" method="post">
                                                                            @method("delete")
                                                                            @csrf
                                                                            <button class="btn btn-sm btn-danger ml-1 deleteBtn" type="button" title="@lang('global.delete')"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    @endcan

                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="7" class="text-center">@lang('global.no_admins')</td>
                                                        </tr>
                                                    @endforelse
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.image')</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.phone_admin')</th>
                                                        <th>@lang('global.is_active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $admins->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

@endsection

