@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.admins')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('roles.index') }}">@lang('sidebar.roles')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.edit')
            </li>
        </ol>
    </div>
@endsection
@section('content')

    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="{{ route('roles.update', $role->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.en_name')</label>
                                                    <input autocomplete="off" type="text" class="form-control" name="name" placeholder="@lang('global.name')" value="{{ old('name', $role->name) }}" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.ar_name')</label>
                                                    <input autocomplete="off" type="text" class="form-control" name="ar_name" placeholder="@lang('global.ar_name')" value="{{ old('ar_name', $role->ar_name) }}" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="custom-hr"><span> @lang('global.permissions')</span></div>

                                        <div class="col-md-12 col-12">
                                            <div class="card collapse-icon accordion-icon-rotate">
                                                <div class="card-body">
                                                    <div class="accordion" id="accordionExample" data-toggle-hover="true">
                                                        @foreach($permissions as $permissions_group)
                                                            <div class="collapse-margin">
                                                                <div class="card-header collapsed bg-primary text-white" id="heading{{ $loop->iteration }}" data-toggle="collapse" role="button" data-target="#collapse{{ $loop->iteration }}" aria-expanded="false" aria-controls="collapse{{ $loop->iteration }}">
                                                                    <span class="lead collapse-title">
                                                                        {{ getRoleName($permissions_group->first()) }}
                                                                    </span>
                                                                    <div class="header-selectable">
                                                                        <button type="button" class="btn btn-sm btn-dark selectAll">@lang('global.select_all')</button>
                                                                        <button type="button" class="btn btn-sm btn-danger deselectAll">@lang('global.deselect_all')</button>
                                                                    </div>
                                                                </div>

                                                                <div id="collapse{{ $loop->iteration }}" class="collapse" aria-labelledby="heading{{ $loop->iteration }}" data-parent="#accordionExample">
                                                                    <div class="card-body">
                                                                        <div class="row">
                                                                            @foreach($permissions_group as $permission)
                                                                                <div class="col-3">
                                                                                    <fieldset>
                                                                                        <div class="vs-checkbox-con vs-checkbox-primary">
                                                                                            <input
                                                                                                type="checkbox"
                                                                                                value="{{ $permission->id }}"
                                                                                                name="permissions[{{$permission->id}}]"
                                                                                                class="p{{$loop->iteration}}
                                                                                                {{ $loop->iteration != 1 ? "selectIndex" : "" }}"
                                                                                                {{ in_array($permission->name, $rolePermissions) ? "checked" : ''}}
                                                                                            >
                                                                                            <span class="vs-checkbox vs-checkbox-lg">
                                                                                                                <span class="vs-checkbox--check">
                                                                                                                    <i class="vs-icon feather icon-check"></i>
                                                                                                                </span>
                                                                                                            </span>
                                                                                            <span class="">{{ getRoleName($permission) }}</span>
                                                                                        </div>
                                                                                    </fieldset>
                                                                                </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="{{ route('roles.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('style')
    <style>
        .header-selectable{
            margin-left: 50px;
        }
        .collapse-margin {
            box-shadow: 0 2px 15px 0 #150101b5;
            text-align: center;
        }
        .custom-hr{
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 15px 0;
        }
        .custom-hr > span{
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }
    </style>
@endpush
@push('scripts')
    <script>
        $(function() {
            $('.selectAll').click(function (evt){
                evt.stopPropagation();
                $(this).closest('.collapse-margin').find('input[type="checkbox"]').prop('checked', true);
            })

            $('.deselectAll').click(function (evt){
                evt.stopPropagation();
                $(this).closest('.collapse-margin').find('input[type="checkbox"]').prop('checked', false);
            })

            $('.selectIndex').on('click', function (evt){
                $(this).closest('.row').find('.p1').prop('checked', true);
            });

            $('.p1').on('click', function (){
                if(!$(this).is(':checked')) {
                    $(this).closest('.row').find('input[type="checkbox"]').prop('checked', false);
                }
            })

        })
    </script>
@endpush
