@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.roles')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('roles.index') }}">@lang('sidebar.roles')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            @can('permissions_create')
                                                <div class="col-2 text-right">
                                                    <a href="{{ route('roles.create') }}" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            @endcan
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.users_count')</th>
                                                        <th>@lang('global.permissions_count')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @forelse($roles as $role)
                                                        <tr class="text-center">
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>{{ getRoleName($role) }}</td>

                                                            <td>{{ $role->users()->count() }}</td>
                                                            <td>{{ $role->permissions()->count() }}</td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    @can('permissions_edit')
                                                                        <a href="{{ route('roles.edit', $role->id) }}" title="@lang('global.edit')" class="btn btn-primary btn-sm ml-1"><i class="fa fa-edit"></i></a>
                                                                    @endcan
                                                                    @can('permissions_delete')
                                                                        <form action="{{ route('roles.destroy', $role->id) }}" method="post">
                                                                            @method("delete")
                                                                            @csrf
                                                                            <button class="btn btn-sm btn-danger ml-1 deleteBtn" type="button" title="@lang('global.delete')"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    @endcan

                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="7" class="text-center">@lang('global.no_permissions')</td>
                                                        </tr>
                                                    @endforelse
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.users_count')</th>
                                                        <th>@lang('global.permissions_count')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $roles->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

@endsection

