@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.complaints_management')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('complaints.index') }}">@lang('global.complaints')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">@lang('global.filters')</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="#">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-role">@lang('global.name')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="{{ request()->input('name') }}" autocomplete="off">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-status">@lang('global.phone')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="phone" value="{{ request()->input('phone') }}" autocomplete="off" type="number">
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> @lang('global.search')</button>
                                <a href="{{ route('complaints.index') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    @lang('global.clear_search')
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.phone')</th>
                                                        <th>@lang('global.message')</th>
                                                        <th>@lang('global.created_at')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                        @forelse($complaints as $complaint)
                                                            <tr class="text-center">
                                                                <td>{{ $loop->iteration }}</td>
                                                                <td data-toggle="tooltip" data-placement="bottom" title="{{$complaint->created_at}}">
                                                                    {{ $complaint->name  }}
                                                                </td>
                                                                <td>{{ $complaint->phone }}</td>
                                                                <td>{{ $complaint->message }}</td>
                                                                <td>{{ optional($complaint->created_at)->diffForHumans() .' / '. optional($complaint->created_at)->format('Y-m-d')}}</td>
                                                                <td>
                                                                    <div class="d-inline-flex action-btn">
                                                                        <button type="button" title="@lang('global.view')" data-id="{{ $complaint->message }}" data-toggle="modal" data-target="#showComplaint" class="btn btn-primary btn-sm mr-2"><i class="fa fa-eye"></i></button>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @empty
                                                            <tr>
                                                                <td colspan="7" class="text-center">@lang('global.no_complaints')</td>
                                                            </tr>
                                                        @endforelse
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.phone')</th>
                                                        <th>@lang('global.created_at')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $complaints->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

    @include('dashboard.complaints_management.complaints.modals.showComplaint')
@endsection
@push('scripts')
    <script>
        $(function() {
            $('#showComplaint').on('show.bs.modal' , function (e) {
                let id = $(e.relatedTarget).data('id');
                $('.clearShowInfo').html('');
                $('.description').html(id);
            });


        })
    </script>
@endpush
@push('style')
    <style>
        .vertical-line{
            display: inline-block;
            border-left: 1px solid #f34b4b;
            margin: 0 10px;
            height: 125px;
        }
    </style>
@endpush
