@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.notifications')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.notifications')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="{{ route('notifications.store') }}" method="post"
                                  enctype="multipart/form-data">
                                @csrf
                                @if(!empty($data))
                                    <div class="col-12 text-center mb-1 imageDiv">
                                        <a href="{{ $data['image'] }}" class="mpImage">
                                            <img src="{{ $data['image'] }}"
                                                 class="img-fluid mb-1 rounded-sm defaultShopImage" style="width: 100px"
                                                 alt="user_image">
                                        </a>
                                        <br>
                                        <h4>{{ $data['name'] }}</h4>
                                    </div>
                                    <input type="hidden" value="{{ $data['image'] }}" name="itemImage">
                                    <input type="hidden" value="{{ $data['id'] }}" name="itemId">
                                    <input type="hidden" value="{{ request()->input('type') }}" name="itemType">
                                @endif
                                <div class="custom-hr"><span> @lang('global.select_user_to_send_notification')</span>
                                </div>
                                <div class="row">
                                    <div class="col-12 pr30px">
                                        <select class="form-control select2Filter usersSelect" name="users_type"
                                                required>
                                            <option value=""> @lang('global.select_user')</option>
                                            <option
                                                value="0" {{ (old('users_type') == '0' ? 'selected' : '') }}> @lang('global.all_users')</option>
                                            <option
                                                value="1" {{ (old('users_type') == '1' ? 'selected' : '') }}> @lang('global.normal_users')</option>
                                            <option
                                                value="2" {{ (old('users_type') == '2' ? 'selected' : '') }}> @lang('global.shop_users')</option>

                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 mt-2">
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.notification_title_ar')</label>
                                                    <input name="title" class="form-control" value="{{ old('title') }}"
                                                           required>
                                                    <small>@lang('global.max_100')</small>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.notification_title_en')</label>
                                                    <input name="title_en" class="form-control" value="{{ old('title') }}"
                                                           required>
                                                    <small>@lang('global.max_100')</small>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        @if(empty($data))
                                            <div class="col-md-6 col-6">
                                                <div class="form-group">
                                                    <div class="controls">
                                                        <label>@lang('global.notification_image')</label>
                                                        <input type="file" name="image" class="form-control"
                                                               value="{{ old('image') }}">
                                                        <div class="help-block"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <label>@lang('global.notification_body_ar')</label>
                                                <textarea cols="12" rows="6" name="body" class="form-control"
                                                          required>{{ old('body') }}</textarea>
                                                <small>@lang('global.max_length')<span
                                                        id="bodyLength">1000</span></small>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <label>@lang('global.notification_body_en')</label>
                                                <textarea cols="12" rows="6" name="body_en" class="form-control"
                                                          required>{{ old('body') }}</textarea>
                                                <small>@lang('global.max_length')<span
                                                        id="bodyLength">1000</span></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @can('notifications_index')
                                    <div class="col-12 d-flex flex-sm-row flex-column justify-content-center mt-1">
                                        <button type="submit"
                                                class="btn btn-primary glow mb-1 mb-sm-0 mr-0 mr-sm-1">@lang('global.send')</button>
                                    </div>
                                @endcan
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Nav Justified Ends -->
@endsection
@push('style')
    <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css/pages/app-user.min.css") }}">
    <style>
        .custom-hr {
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 30px 0;
        }

        .custom-hr > span {
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }

        .userActive {
            background-color: #38347a !important;
        }

        .pr30px {
            padding-right: 30px;
        }
    </style>
@endpush
@push('scripts')
    <script>
        $(function () {
            let dir = "{{ getDir() }}";
            $('#replayType').on('change', function () {
                $('#bodyLength').html(2048);
            })

            $('.sendToAllCheckBox').on('click', function () {
                $('.select2Filter').val(null).trigger("change");
            })

            $('.select2Filter').on('select2:select', function () {
                $('.sendToAllCheckBox').prop('checked', false);
            })

        })
    </script>
@endpush
