@extends('dashboard.layout.main')
@section('breadcrumbs')
<h2 class="content-header-title float-left mb-0">@lang('sidebar.financial_management')</h2>
<div class="breadcrumb-wrapper col-12">
    <ol class="breadcrumb">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
        </li>
        <li class="breadcrumb-item">
            <a href="#">@lang('sidebar.financial_management')</a>
        </li>
        <li class="breadcrumb-item active">
            <a href="{{ route('payment_subscription') }}">@lang('global.subscriptions')</a>
        </li>
    </ol>
</div>
@endsection
@section('content')
<section class="users-list-wrapper">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">@lang('global.filters')</h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                </ul>
            </div>
        </div>
        <div class="card-content collapse show">
            <div class="card-body">
                <div class="users-list-filter">
                    <form action="#">
                        <div class="row">
                            <div class="col-12 col-sm-6 col-lg-3">
                                <label for="users-list-role">@lang('global.shop_name')</label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="user_id" id="users-list-verified">
                                        <option value="">@lang('global.all')</option>
                                        @foreach($shops as $shop)
                                        @if($shop)
                                        <option value="{{ $shop->id }}"
                                            {{ request()->input('user_id') == $shop->id ? "selected" : "" }}>
                                            {{ $shop->display_shop_name }}</option>
                                        @endif
                                        @endforeach
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-3">
                                <label for="users-list-role">@lang('global.category_name')</label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="category_id" id="users-list-verified">
                                        <option value="">@lang('global.all')</option>
                                        @foreach($categories as $category)
                                        @if(isset($shop))
                                        <option value="{{ $category->id }}"
                                            {{ request()->input('category_id') == $category->id ? "selected" : "" }}>
                                            {{ $category->name }}</option>
                                        @endif
                                        @endforeach
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified">@lang('global.payment_id')</label>
                                <fieldset class="form-group">
                                    <input type="text" class="form-control" name="payment_id"
                                        value="{{ request()->input('payment_id') }}"
                                        placeholder="@lang('global.payment_id')" autocomplete="off">
                                    <div class="help-block"></div>
                                </fieldset>
                            </div>

                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified">@lang('global.date')</label>
                                <fieldset class="form-group">
                                    <input type="date" class="form-control" name="date"
                                        value="{{ request()->input('date') }}"
                                        placeholder="@lang('global.date')">
                                    <div class="help-block"></div>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified">@lang('global.status')</label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="status" id="users-list-verified">
                                        <option value="">@lang('global.all')</option>
                                        <option value="SUCCESS"
                                            {{ request()->input('status') === "SUCCESS" ? "selected" : "" }}>
                                            @lang('global.success')</option>
                                        <option value="PENDING"
                                            {{ request()->input('status') === "PENDING" ? "selected" : "" }}>
                                            @lang('global.pending')</option>
                                        <option value="PROCCESSING"
                                            {{ request()->input('status') === "PROCCESSING" ? "selected" : "" }}>
                                            @lang('global.processing')</option>
                                        <option value="FAILED"
                                            {{ request()->input('status') === "FAILED" ? "selected" : "" }}>
                                            @lang('global.failed')</option>
                                    </select>
                                </fieldset>
                            </div>
                        </div>
                        <div class="d-flex justify-content-center">
                            <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i>
                                @lang('global.search')</button>
                            <a href="{{ route('payment_subscription') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                @lang('global.clear_search')
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"></h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li>
                        <a data-action="collapse"><i class="feather icon-chevron-down"></i></a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="card-content collapse show">
            <div class="card-body">
                <section id="column-selectors">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-content">
                                    <div class="card-body card-dashboard">
                                        <div class="table-responsive">
                                            <table class="table table-striped datatableInit nowrap">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        {{-- Checked --}}
                                                        <th>@lang('global.payment_id')</th>
                                                        {{-- Created On --}}
                                                        <th>@lang('global.created_at')</th>
                                                        {{-- Start Date (Subscription start date) --}}
                                                        <th>@lang('global.start_date')</th>
                                                        {{-- End Date (Subscription start date) --}}
                                                        <th>@lang('global.end_date')</th>
                                                        {{-- Shop Name --}}
                                                        <th>@lang('global.shop_name_english')</th>
                                                        <th>@lang('global.shop_name_arabic')</th>
                                                        {{-- Category --}}
                                                        <th>@lang('global.category_name')</th>
                                                        {{-- Price --}}
                                                        <th>@lang('global.price')</th>
                                                        {{-- Status --}}
                                                        <th>@lang('global.status')</th>
                                                        {{-- More Actions --}}
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($subscriptions as $subscription)
                                                    <tr class="text-center">
                                                        <td>{{ $loop->iteration }}</td>
                                                        {{-- Payment Ref ID --}}
                                                        <td>{{ $subscription->payment_id }}</td>
                                                        {{-- Created On (Payment) --}}
                                                        <td>{{ optional($subscription->payment)->created_at }}</td>
                                                        {{-- Subscription start date --}}
                                                        <td>{{ $subscription->valid_from }}</td>
                                                        {{-- Subscription end date --}}
                                                        <td>{{ $subscription->valid_to }}</td>
                                                        {{-- Shop Name --}}
                                                        <td>{{ optional($subscription->shop)->shop_name_en }}</td>
                                                        <td>{{ optional($subscription->shop)->shop_name}}</td>
                                                        {{-- Category --}}
                                                        <td>{{ optional($subscription->category)->name }}</td>
                                                        {{-- Price --}}
                                                        <td>{{ optional($subscription->payment)->amount }}</td>
                                                        {{-- Status --}}
                                                        <td>{{ optional($subscription->payment)->status }}</td>
                                                        {{-- Show Actions --}}
                                                        <td>
                                                            <a href="{{ route('payment_subscription.single', $subscription->id) }}" class="btn btn-info btn-sm">
                                                                <i class="fa fa-ellipsis-h"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                    @empty
                                                    <tr>
                                                        <td colspan="8" class="text-center">
                                                            @lang('global.no_payment_transactions')</td>
                                                    </tr>
                                                    @endforelse
                                                </tbody>
                                                <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        {{-- Checked --}}
                                                        <th>@lang('global.payment_id')</th>
                                                        {{-- Created On --}}
                                                        <th>@lang('global.shop_name')</th>
                                                        {{-- Start Date (Subscription start date) --}}
                                                        <th>@lang('global.category_name')</th>
                                                        {{-- Shop Name --}}
                                                        <th>@lang('global.package_name')</th>
                                                        {{-- Category --}}
                                                        <th>@lang('global.auto_renew')</th>
                                                        {{-- Price --}}
                                                        <th>@lang('global.status')</th>
                                                        {{-- Status --}}
                                                        <th>@lang('global.package_days')</th>
                                                        {{-- More Actions --}}
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                        <div class="pagination">
                                            {{ $subscriptions->appends(request()->input())->links() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
</section>

@endsection
@push('scripts')
<script>
    $(function () {
        $('#showInfo').on('show.bs.modal', function (e) {
            let info = $(e.relatedTarget).data('info');
            $('.clearShowInfo').html('');
            $('.username').html(info.user ? info.user.name : '');
            $('.accountName').html(info.account_name);
            $('.accountNumber').html(info.account_number);
            $('.amount').html(info.amount + " @lang('global.sar')");
            $('.ibanNumber').html(info.iban_number);
            $('.isExported').html(info.is_exported);
            $('.createdAt').html(info.created_at);
        });

        $('#changeStatus').on('show.bs.modal', function (e) {
            let id = $(e.relatedTarget).data('id');
            $('#withdrawalId').val(id);
        });

    })

</script>
@endpush
