@extends('dashboard.layout.main')
@section('breadcrumbs')
<h2 class="content-header-title float-left mb-0">@lang('global.subscriptions')</h2>

@endsection
@section('content')
<section class="users-list-wrapper">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"></h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li>
                        <a data-action="collapse"><i class="feather icon-chevron-down"></i></a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="card-content collapse show">
            <div class="card-body">
                <section id="column-selectors">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-content">
                                    <div class="card-body card-dashboard">
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.payment_id')</span>
                                            <span class="col-sm">{{ $subscription->payment_id }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.created_at')</span>
                                            <span class="col-sm">{{ $subscription->payment->created_at }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.start_date')</span>
                                            <span class="col-sm">{{ $subscription->valid_from }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.end_date')</span>
                                            <span class="col-sm">{{ $subscription->valid_to }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.shop_name')</span>
                                            <span class="col-sm">{{ $subscription->shop->display_shop_name }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.category_name')</span>
                                            <span class="col-sm">{{ $category->name }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.package_name')</span>
                                            <span class="col-sm">{{ $subscription->package->name }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.price')</span>
                                            <span class="col-sm">{{ $subscription->payment->amount }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.status')</span>
                                            <span class="col-sm">{{ $subscription->payment->status }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.auto_renew')</span>
                                            <span class="col-sm">{{ $subscription->payment->auto_renew }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start row">
                                            <span class="col-sm font-weight-bold">@lang('global.package_days')</span>
                                            <span class="col-sm">{{ $subscription->package->days }}</span>
                                        </div>
                                        <div class="d-flex justify-content-start p-2 row">
                                            <div class="col-sm">
                                                <a href="{{ route('payment_subscription') }}" class="btn btn-warning">@lang('global.back')</a>
                                            </div>
                                            <div class="col-sm">
                                                <form action="{{ route('payment_subscription.status') }}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="payment_id" value="{{ $subscription->payment_id }}">
                                                    <div class="input-group d-flex">
                                                        <div class="input-group-prepend">
                                                          <label class="input-group-text" for="inputGroupSelect01">@lang('global.status')</label>
                                                        </div>
                                                        <select name="payment_status" class="custom-select" id="inputGroupSelect01">
                                                          <option selected>@lang('global.choose')</option>
                                                          @foreach ($status as $item)
                                                            <option value="{{ $item }}">{{ $item }}</option>
                                                          @endforeach
                                                        </select>
                                                        <button type="submit" class="btn btn-primary">@lang('global.save')</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
</section>

@endsection
@push('scripts')
<script>
    $(function () {
        $('#showInfo').on('show.bs.modal', function (e) {
            let info = $(e.relatedTarget).data('info');
            $('.clearShowInfo').html('');
            $('.username').html(info.user ? info.user.name : '');
            $('.accountName').html(info.account_name);
            $('.accountNumber').html(info.account_number);
            $('.amount').html(info.amount + " @lang('global.sar')");
            $('.ibanNumber').html(info.iban_number);
            $('.isExported').html(info.is_exported);
            $('.createdAt').html(info.created_at);
        });

        $('#changeStatus').on('show.bs.modal', function (e) {
            let id = $(e.relatedTarget).data('id');
            $('#withdrawalId').val(id);
        });

    })

</script>
@endpush
