@extends('dashboard.layout.main')
@section('breadcrumbs')
<h2 class="content-header-title float-left mb-0">@lang('sidebar.financial_management')</h2>
<div class="breadcrumb-wrapper col-12">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
        </li>
        <li class="breadcrumb-item"><a href="#">@lang('sidebar.financial_management')</a>
        </li>
        <li class="breadcrumb-item active"><a
                href="{{ route('subscriptions.index') }}">@lang('global.subscriptions')</a>
        </li>
    </ol>
</div>
@endsection
@section('content')
<section class="users-list-wrapper">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">@lang('global.filters')</h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                </ul>
            </div>
        </div>
        <div class="card-content collapse show">
            <div class="card-body">
                <div class="users-list-filter">
                    <form action="#">
                        <div class="row">
                            <div class="col-12 col-sm-6 col-lg-3">
                                <label for="users-list-role">@lang('global.shop_name')</label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="user_id" id="users-list-verified">
                                        <option value="">@lang('global.all')</option>
                                        @foreach($shops as $shop)
                                        @if($shop)
                                        <option value="{{ $shop->id }}"
                                            {{ request()->input('user_id') == $shop->id ? "selected" : "" }}>
                                            {{ $shop->display_shop_name }}</option>
                                        @endif
                                        @endforeach
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-3">
                                <label for="users-list-role">@lang('global.category_name')</label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="category_id" id="users-list-verified">
                                        <option value="">@lang('global.all')</option>
                                        @foreach($categories as $category)
                                        @if($category)
                                        <option value="{{ $category->id }}"
                                            {{ request()->input('category_id') == $category->id ? "selected" : "" }}>
                                            {{ $category->name }}</option>
                                        @endif
                                        @endforeach
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified">@lang('global.from_date')</label>
                                <fieldset class="form-group">
                                    <input type="text" class="form-control specialToInput" name="from_date"
                                        value="{{ request()->input('from_date') }}"
                                        placeholder="@lang('global.from_date')" autocomplete="off">
                                    <div class="help-block"></div>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified">@lang('global.to_date')</label>
                                <fieldset class="form-group">
                                    <input type="text" class="form-control specialToInput" name="to_date"
                                        value="{{ request()->input('to_date') }}" placeholder="@lang('global.to_date')"
                                        autocomplete="off">
                                    <div class="help-block"></div>
                                </fieldset>
                            </div>

                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified">@lang('global.active')</label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="is_active" id="users-list-verified">
                                        <option value="">@lang('global.all')</option>
                                        <option value="1" {{ request()->input('is_active') === "1" ? "selected" : "" }}>
                                            @lang('global.active')</option>
                                        <option value="0" {{ request()->input('is_active') === "0" ? "selected" : "" }}>
                                            @lang('global.not_active')</option>
                                    </select>
                                </fieldset>
                            </div>
                        </div>
                        <div class="d-flex justify-content-center">
                            <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i>
                                @lang('global.search')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"></h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                </ul>
            </div>
        </div>
        <div class="card-content collapse show">
            <div class="card-body">
                <section id="column-selectors">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row col-12">
                                        <div class="col-10" id="dataTableExport"></div>
                                    </div>
                                </div>
                                <div class="card-content">
                                    <div class="card-body card-dashboard">
                                        <div class="table-responsive">
                                            <table class="table table-striped datatableInit nowrap">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.shop_name')</th>
                                                        <th>@lang('global.category_name')</th>
                                                        <th>@lang('global.package_name')</th>
                                                        <th>@lang('global.from_date')</th>
                                                        <th>@lang('global.to_date')</th>
                                                        <th>@lang('global.is_valid')</th>
                                                        <th>@lang('global.payment_cost')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($subscriptions as $subscribe)
                                                    <tr class="text-center">
                                                        <td>{{ $loop->iteration }}</td>
                                                        <td>{{ optional($subscribe->shop)->display_shop_name }}</td>
                                                        <td>{{ optional($subscribe->category)->name }}</td>
                                                        <td>{{ optional($subscribe->current_status_json)[(app()->getLocale().'_name')] }}
                                                        </td>
                                                        <td data-toggle="tooltip" data-placement="bottom"
                                                            title="{{$subscribe->valid_from}}">
                                                            {{ $subscribe->valid_from->toDateString() }}
                                                        </td>
                                                        <td data-toggle="tooltip" data-placement="bottom"
                                                            title="{{$subscribe->valid_to}}">
                                                            {{ $subscribe->valid_to->toDateString() }}
                                                        </td>
                                                        <td class="is_active"><i
                                                                class="fa fa-{{$subscribe->is_active ? "check text-success" : "times text-danger"}}"></i>
                                                        </td>
                                                        <td>{{ optional($subscribe->payment)->amount }}</td>

                                                    </tr>
                                                    @empty
                                                    <tr>
                                                        <td colspan="8" class="text-center">
                                                            @lang('global.no_subscriptions')</td>
                                                    </tr>
                                                    @endforelse
                                                    <tr></tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.shop_name')</th>
                                                        <th>@lang('global.category_name')</th>
                                                        <th>@lang('global.package_name')</th>
                                                        <th>@lang('global.from_date')</th>
                                                        <th>@lang('global.to_date')</th>
                                                        <th>@lang('global.is_valid')</th>
                                                        <th>@lang('global.payment_cost')</th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                        <div class="pagination">
                                            {{ $subscriptions->appends(request()->input())->links() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
</section>

@endsection
@push('scripts')
<script>
    $(function () {
        $('.specialToInput').datetimepicker({
            timepicker: false,
            format: 'Y/m/d'
        });
    })

</script>
@endpush
