@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.marketer')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="{{ route('marketer.index') }}">@lang('sidebar.marketer')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.edit')
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="{{ route('marketer.update', $marketer->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="form-body">
                                    <div class="row mb-2">
                                        <div class="col-md-3 col-lg-3 col-6 text-center ProductImage"></div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.name_en')</label>
                                                    <input class="form-control" name="name_en" value="{{$marketer->name_en}}" autocomplete="off" placeholder="Name">                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.name_ar')</label>
                                                    <input class="form-control" name="name_ar" value="{{$marketer->name_ar}}" autocomplete="off" placeholder="Name">                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.discount_percentage')</label>
                                                    <input class="form-control" name="discount_percentage" value="{{$marketer->discount_percentage}}" autocomplete="off" placeholder="Name">                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.marketer_code')</label>
                                                    <input class="form-control" name="marketer_code" value="{{$marketer->marketer_code}}" autocomplete="off" placeholder="Name">                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 text-center">
                                        <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                        <a href="{{ route('marketer.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('style')
@endpush

