@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.marketer')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="{{ route('marketer.index') }}">@lang('sidebar.marketer')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">@lang('global.filters')</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="#">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-role">@lang('global.marketer_code')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="marketer_code" value="{{ request()->input('marketer_code') }}" autocomplete="off">
                                    </fieldset>
                                </div>

                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> @lang('global.search')</button>
                                <a href="{{ route('marketer.index') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    @lang('global.clear_search')
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            @can('admins_create')
                                                <div class="col-2 text-right">
                                                    <a href="{{ route('marketer.create') }}" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            @endcan
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.discount_percentage')</th>
                                                        <th>@lang('global.marketer_code')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @forelse($marketers as $marketer)
                                                        <tr class="text-center">
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>{{$marketer->name_en}}</td>
                                                            <td>{{$marketer->discount_percentage}}</td>
                                                            <td>{{$marketer->marketer_code}}</td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    @can('marketers_edit')
                                                                        <a href="{{ route('marketer.edit', $marketer->id) }}"
                                                                           title="@lang('global.edit')"
                                                                           class="btn btn-primary btn-sm ml-1"><i
                                                                                class="fa fa-edit"></i></a>
                                                                    @endcan
                                                                    @can('marketers_delete')
                                                                        <form
                                                                            action="{{ route('marketer.destroy', $marketer->id) }}"
                                                                            method="post">
                                                                            @method("delete")
                                                                            @csrf
                                                                            <button
                                                                                class="btn btn-sm btn-danger ml-1 deleteBtn"
                                                                                type="button"
                                                                                title="@lang('global.delete')"><i
                                                                                    class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    @endcan
                                                                    <a href="{{ route('marketer.show', $marketer->id) }}"
                                                                       title="@lang('global.view')"
                                                                       class="btn btn-primary btn-sm ml-1"><i
                                                                            class="fa fa-eye"></i></a>

                                                                </div>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="7"
                                                                class="text-center">@lang('global.no_marketers')</td>
                                                        </tr>
                                                    @endforelse
                                                    </tbody>

                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $marketers->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

@endsection

@push('style')
    <style>
        .vertical-line {
            display: inline-block;
            border-left: 1px solid #f34b4b;
            margin: 0 10px;
            height: 125px;
        }
    </style>
@endpush
