@extends('dashboard.layout.main')
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link rel="stylesheet" href="/resources/demos/style.css">
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.marketer')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="{{ route('marketer.index') }}">@lang('sidebar.marketer')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.view')
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            {{--                            {{$marketer}}--}}

                            <div class="card-body p-9">

                                <div class="row mb-7 mt-75">
                                    <label class="col-lg-4 fw-bold text-muted">@lang('global.name_en')</label>
                                    <div class="col-lg-8">
                                        <span class="fw-bolder fs-6 text-gray-800">{{$marketer->name_en}}</span>
                                    </div>
                                </div>
                                <div class="row mb-7 mt-75">
                                    <label class="col-lg-4 fw-bold text-muted">@lang('global.name_ar')</label>
                                    <div class="col-lg-8">
                                        <span class="fw-bolder fs-6 text-gray-800">{{$marketer->name_ar}}</span>
                                    </div>
                                </div>
                                <div class="row mb-7 mt-75">
                                    <label
                                        class="col-lg-4 fw-bold text-muted">@lang('global.discount_percentage')</label>
                                    <div class="col-lg-8">
                                        <span
                                            class="fw-bolder fs-6 text-gray-800">{{$marketer->discount_percentage}} %</span>
                                    </div>
                                </div>
                                <div class="row mb-7 mt-75">
                                    <label class="col-lg-4 fw-bold text-muted">@lang('global.marketer_code')</label>
                                    <div class="col-lg-8">
                                        <span class="fw-bolder fs-6 text-gray-800">{{$marketer->marketer_code}}</span>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    {{--    @if($transactions!='[]')--}}
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-4">
                                            <h4 class="mt-75">@lang('global.subscribers')</h4>
                                        </div>
                                        <div class="row col-8">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <div class="col-2 text-right">
                                                <button id="export_event"
                                                        class="btn btn-primary ms-3 mb-75">@lang('global.export')</button>
                                                <form method="post" action="{{route('export',$marketer->id)}}"
                                                      id="event_export_form">
                                                    @csrf
                                                    <input type="hidden" name="sub_date" id="sub_date" value="">
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-content">

                                    <div class="card-content collapse show">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-12 col-sm-6 col-lg-4">
                                                    <label
                                                        for="users-list-role">@lang('global.subscription_date')</label>
                                                    <fieldset class="form-group">
                                                        <input class="form-control" type="text"
                                                               id="datepicker"></p>
                                                    </fieldset>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body card-dashboard" id="tableContainer">
                                        @include('dashboard.marketer.subscribers')
                                    </div>
                                </div>
                            </div>
                        </div>

                    </section>

                </div>
            </div>
        </div>
    </section>
    {{--    @endif--}}

@endsection
@push('style')
@endpush



@push('scripts')
    <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
    <script>

        $(() => {
            $('#export_event').click(function () {
                $("#event_export_form").submit();
            });
        });
        $("#datepicker")
            .datepicker({
                onSelect: function (dateText) {
                    console.log("Selected date: " + dateText + "; input's current value: " + this.value);
                    $(this).change();
                    $('#sub_date').val(this.value);
                    var searchKey = this.value;
                    var marketerId = '{{$marketer->id}}';
                    $.ajax({
                        method: 'GET',
                        url: "{{ route('searchSubscriber') }}",
                        data: {searchKey: searchKey, id: marketerId, "_token": "{{ csrf_token() }}"},
                        success: function (data) {
                            $('#tableContainer').html(data.html);
                        },
                        error: function () {
                            alert("There is an error.");
                        }
                    });
                }
            })
            .on("change", function () {
                console.log("Got change event from field");
            });

    </script>
@endpush


