<div class="table-responsive">
    <table class="table table-striped datatableInit nowrap">
        <thead>
        <tr class="text-center">
            <th>#</th>
            <th>@lang('global.shop_name_arabic')</th>
            <th>@lang('global.shop_name_english')</th>
            <th>@lang('global.category')</th>
            <th>@lang('global.discount_percentage')</th>
            <th>@lang('global.amount')</th>
            <th>@lang('global.subscription_plan')</th>
            <th>@lang('global.subscription_type')</th>
            <th>@lang('global.subscribe_date')</th>
            <th>@lang('global.subscribe_date_end')</th>
        </tr>
        </thead>
        <tbody id="table_body">
        @forelse($transactions as $transaction)
            <tr class="text-center">
                <td>{{$loop->iteration}}</td>
                <td>{{$transaction->user->shop_name}}</td>
                <td>{{$transaction->user->shop_name_en}}</td>
                <td>{{$transaction->category->name}}</td>
                <td>{{$marketer->discount_percentage}}</td>
                <td>{{$transaction->amount}}</td>
                <td>{{$transaction->packagehistory->ar_name}}</td>
                <td>{{ \Str::contains(json_encode($transaction->response), 'Free')?'Free Subscriber':'Paid Subscriber' }}</td>
                <td>{{$transaction->created_at}}</td>
                <td>{{$transaction->created_at->addDays($transaction->subscribe_days)}}</td>
            </tr>
        @empty
            <tr>
                <td colspan="9
                "
                    class="text-center">@lang('global.no_subscribers')
                </td>
            </tr>
        @endforelse
        </tbody>

    </table>
</div>
<div class="pagination">
    {{ $transactions->appends(request()->input())->links() }}
</div>
