@extends('dashboard.layout.main')
@push('style')
    <link rel="stylesheet" media="screen" type="text/css" href="{{ asset('assets/colorpicker/css/colorpicker.css') }}" />
@endpush
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.categories')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.master_data')</a>
            </li>
            <li class="breadcrumb-item "><a href="{{ route('categories.index') }}">@lang('sidebar.categories')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.edit')
            </li>
        </ol>
    </div>
@endsection
@section('content')

    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="{{ route('categories.update', $category->id) }}" method="post" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.ar_name')</label>
                                                    <input type="text" class="form-control" name="ar_name" placeholder="@lang('global.ar_name')" value="{{ old('ar_name', $category->ar_name) }}" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.en_name')</label>
                                                    <input type="text" class="form-control" name="en_name" placeholder="@lang('global.en_name')" value="{{ old('en_name', $category->en_name) }}" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.active')</label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                        <option value="1" {{ old('is_active', $category->is_active) == 1 ? "selected" : "" }}>@lang('global.active')</option>
                                                        <option value="0" {{ !is_null(old('is_active', $category->is_active)) && old('is_active', $category->is_active) == 0 ? "selected" : "" }}>@lang('global.not_active')</option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.bg_color')</label>
                                                   <input type="color" id="bg_color" name="bg_color" value="{{ $category->bg_color }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <hr/>
                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="{{ route('categories.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('scripts')
    <script type="text/javascript" src="{{ asset('assets/colorpicker/js/colorpicker.js') }}"></script>
    <script>
        $('#bg_color').ColorPicker({
            livePreview:true,
            onShow: function (colpkr) {
                $(colpkr).fadeIn(500);
                return false;
            },
            onHide: function (colpkr) {
                $(colpkr).fadeOut(500);
                return false;
            },
            onChange: function (hsb, hex, rgb) {
                $('#bg_color').val('#'+hex);
            }
        });
    </script>
@endpush
