@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.categories')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.master_data')</a>
            </li>
            <li class="breadcrumb-item "><a href="{{ route('categories.index') }}">@lang('sidebar.categories')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">@lang('global.filters')</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="{{ route("categories.index") }}">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-role">@lang('global.name')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="{{ request()->input('name') }}" autocomplete="off">
                                    </fieldset>
                                </div>

                                <div class="col-12 col-sm-6 col-lg-6">
                                    <input type="hidden" class="form-control" name="user_id" value="{{ request()->user_id }}" autocomplete="off">
                                </div>
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-verified">@lang('global.active')</label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value="">@lang('global.all')</option>
                                            <option value="1" {{ request()->input('is_active') === "1" ? "selected" : "" }}>@lang('global.active')</option>
                                            <option value="0" {{ request()->input('is_active') === "0" ? "selected" : "" }}>@lang('global.not_active')</option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> @lang('global.search')</button>
                                <a href="{{ route('categories.index') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    @lang('global.clear_search')
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements"></div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-9" id="dataTableExport"></div>
                                            @can('categories_arrange')
                                                <div class="col-2 text-right">
                                                    <button type="button" class="btn bg-gradient-success waves-effect waves-light" data-toggle="modal" data-target="#categoryOrder">@lang('global.reorder_categories') </button>
                                                </div>
                                            @endcan
                                            @can('categories_index')
                                            <div class="col-1 text-right">
                                                <a href="{{ route('categories.create') }}" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                            </div>
                                            @endcan
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.bg_color')</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.shops_count')</th>
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                        @forelse($categories as $category)
                                                            <tr class="text-center">
                                                                <td>{{ $loop->iteration }}</td>
                                                                <td>
                                                                    <div style="background-color: {{ $category->bg_color }}; border: #0a0a0a solid 1px;height: 2rem"></div>
                                                                </td>
                                                                <td>{{ $category->name }}</td>
                                                                <td><a>{{ $category->shops_count }}</a></td>
                                                                <td class="is_active"><i class="fa fa-{{$category->is_active ? "check text-success" : "times text-danger"}}"></i></td>
                                                                <td>
                                                                    <div class="d-inline-flex action-btn">
                                                                        @can('categories_edit')
                                                                            <a href="{{ route('categories.edit', $category->id) }}" title="@lang('global.edit')" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>
                                                                            @if($category->is_active)
                                                                                <a href="#" title="@lang('global.deactivate')" data-id="{{ $category->id }}" data-route="{{ route('toggleCategoryStatus') }}" data-message="@lang('global.deactivate_category')" data-alt-msg="@lang('global.activate_category')" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                            @else
                                                                                <a href="#" title="@lang('global.activate')" data-id="{{ $category->id }}" data-route="{{ route('toggleCategoryStatus') }}" data-message="@lang('global.activate_category')" data-alt-msg="@lang('global.deactivate_category')" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                            @endif
                                                                        @endcan
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @empty
                                                            <tr>
                                                                <td colspan="7" class="text-center">@lang('global.no_categories')</td>
                                                            </tr>
                                                        @endforelse
                                                        <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr  class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.bg_color')</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.shops_count')</th>
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $categories->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="categoryOrder" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryOrderTitle">@lang('global.sort')</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body slick">
                    <div id="simple-list" class="row">
                        <div class="list-group col slick">
                            @foreach($categories_orders as $cat)
                                <div class="list-group-item" data-id="{{ $cat->id }}">{{ $cat->name }}</div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary submitOrder">@lang('global.save')</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">@lang('global.close')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
    <style>
        .avatar {
            background-color: unset;
        }
        .list-group-item {
            margin: 2px 115px !important;
            text-align: center !important;
            background-color: #0041fa26 !important;
            color: black !important;
        }
        .sortableSelected{
            background-color: #95c88f !important;
            color: #0C102A !important;
        }
    </style>
@endpush
@push('scripts')
    <script>
        $(function(){
            $(".slick").sortable({
                animation: 150,
                ghostClass: 'bg-dark',
                multiDrag: true,
                selectedClass: 'sortableSelected',
            });

            $('.submitOrder').on('click', function (evt){
                let cats = $('.slick').find('.list-group-item').map((index, elem) => {return {order: index+1 , id: $(elem).data('id')}}).toArray();
                $.Toast.showToast({
                    "title": "@lang('global.wait_to_proceed')",
                    "icon": "loading",
                    "duration" : -1,
                });
                $.ajax({
                    method : 'POST',
                    url : '{{ route('reorderCategories') }}',
                    data : {orders : cats, _token : '{{ csrf_token() }}'},
                    success : (response) => {
                        $.Toast.hideToast();
                        $.Toast.showToast({
                            "title": "@lang('global.reorder_done')",
                            "icon": "success",
                            "duration" : 1500,
                        });
                        window.location.reload();
                    },
                    error: (response) => {
                        $.Toast.hideToast();
                        $.Toast.showToast({
                            "title": "@lang('global.failed_to_reorder')",
                            "icon": "error",
                            "duration" : 3000,
                        });
                    }
                })
            });
            // reorderCategory() {
            //     let cats = this.$refs.ordered.categories;
            //     let lastData = {orders: cats.map((cat)=> {return {order:cats.indexOf(cat)+1, id:cat.id};})};
            //     console.log(lastData);
            //     let loader = this.$loading.show({
            //         loader: 'dots'
            //     });
            //     reorderCategories(lastData).then( (response) => {
            //         this.categories = response.data;
            //         loader.hide();
            //         this.orderCat.modalStatus = false;
            //         this.$swal('','تم اعادة ترتيب الاقسام بنجاح','success');
            //     }).catch((error) => {
            //         loader.hide();
            //         if (error.response.data.message != null) {
            //             this.$swal('', error.response.data.message, 'error');
            //         } else {
            //             this.$swal('', 'حدث خطأ برجاء المحاولة مرة أخرى', 'error');
            //         }
            //     });
            // }
        })
    </script>
@endpush
