@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.countries')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.master_data')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('countries.index') }}">@lang('sidebar.countries')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">@lang('global.filters')</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="{{ route("countries.index") }}">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-role">@lang('global.name')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="{{ request()->input('name') }}" autocomplete="off">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-verified">@lang('global.active')</label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value="">@lang('global.all')</option>
                                            <option value="1" {{ request()->input('is_active') === "1" ? "selected" : "" }}>@lang('global.active')</option>
                                            <option value="0" {{ request()->input('is_active') === "0" ? "selected" : "" }}>@lang('global.not_active')</option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> @lang('global.search')</button>
                                <a href="{{ route('countries.index') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    @lang('global.clear_search')
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            @can('countries_create')
                                            <div class="col-2 text-right">
                                                <a href="{{ route('countries.create') }}" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                            </div>
                                            @endcan
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.currency')</th>
                                                        <th>@lang('global.code')</th>
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                        @forelse($countries as $country)
                                                            <tr class="text-center">
                                                                <td>{{ $loop->iteration }}</td>
                                                                <td>{{ $country->name }}</td>
                                                                <td>{{ $country->currency }}</td>
                                                                <td>{{ $country->code }}</td>
                                                                <td class="is_active"><i class="fa fa-{{$country->is_active ? "check text-success" : "times text-danger"}}"></i></td>
                                                                <td>
                                                                    <div class="d-inline-flex action-btn">
                                                                        @can('countries_edit')
                                                                            <a href="{{ route('countries.edit', $country->id) }}" title="@lang('global.edit')" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>

                                                                            @if($country->is_active)
                                                                                <a href="#" title="@lang('global.deactivate')" data-id="{{ $country->id }}" data-route="{{ route('toggleCountryStatus') }}" data-message="@lang('global.deactivate_country')" data-alt-msg="@lang('global.activate_country')" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                            @else
                                                                                <a href="#" title="@lang('global.activate')" data-id="{{ $country->id }}" data-route="{{ route('toggleCountryStatus') }}" data-message="@lang('global.activate_country')" data-alt-msg="@lang('global.deactivate_country')" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                            @endif
{{--                                                                        @if($country->code != '+974')--}}
{{--                                                                            <form action="{{ route('countries.destroy', $country->id) }}" method="post">--}}
{{--                                                                                @method("delete")--}}
{{--                                                                                @csrf--}}
{{--                                                                                <button class="btn btn-sm btn-danger deleteBtn" type="button" title="@lang('global.delete')" data-message="@lang('global.cannot_recovery_country')"><i class="fas fa-trash"></i></button>--}}
{{--                                                                            </form>--}}
{{--                                                                        @endif--}}
                                                                        @endcan
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @empty
                                                            <tr>
                                                                <td colspan="7" class="text-center">@lang('global.no_countries')</td>
                                                            </tr>
                                                        @endforelse
                                                        <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.name')</th>
                                                        <th>@lang('global.code')</th>
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $countries->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

@endsection

