@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.packages')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.master_data')</a>
            </li>
            <li class="breadcrumb-item"><a href="{{ route('packages.index') }}">@lang('sidebar.packages')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.edit')
            </li>
        </ol>
    </div>
@endsection
@section('content')

    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="{{ route('packages.update', $package->id) }}" method="post" >
                                @csrf
                                @method("PUT")

                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.ar_name')</label>
                                                    <input type="text" class="form-control" name="ar_name" placeholder="@lang('global.ar_name')" value="{{ old('ar_name', $package->ar_name) }}" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.en_name')</label>
                                                    <input type="text" class="form-control" name="en_name" placeholder="@lang('global.en_name')" value="{{ old('en_name', $package->en_name) }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.cost')</label>
                                                    <input type="text" class="form-control" name="cost" placeholder="@lang('global.cost')" value="{{ old('cost', $package->cost) }}" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.days')</label>
                                                    <input type="text" class="form-control" name="days" placeholder="@lang('global.days')" value="{{ old('days', $package->days) }}" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.active')</label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="@lang('global.this_filed_required')">
{{--                                                        <option value="" {{ is_null(old('is_active', $package->is_active)) == 1 ? "selected" : "" }}>@lang('global.select_is_active')</option>--}}
                                                        <option value="1" {{ old('is_active', $package->is_active) == 1 ? "selected" : "" }}>@lang('global.active')</option>
                                                        <option value="0" {{ !is_null(old('is_active', $package->is_active)) && old('is_active', $package->is_active) == 0 ? "selected" : "" }}>@lang('global.not_active')</option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="{{ route('packages.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
