<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Blockat">
    <meta name="keywords" content="Blockat">
    <meta name="author" content="Blockat">
    <title>@lang('global.blockat')</title>
    <link rel="apple-touch-icon" href="{{ asset('/dashboard/images/ico/apple-icon-120.png') }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('/dashboard/images/ico/favicon.ico') }}">
    <link rel="stylesheet" href="{{ asset('dashboard/css/fontawesome/css/all.css') }}" />
    <link rel="stylesheet" media="screen" href="https://fontlibrary.org//face/droid-arabic-kufi" type="text/css" />
    @if (in_array(app()->getLocale(), ['ar']))
        <!-- BEGIN: Theme CSS-->
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css-rtl/bootstrap.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css-rtl/bootstrap-extended.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css-rtl/colors.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css/custom.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css-rtl/components.css') }}">
        @stack('style_rtl')
    @else
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css/bootstrap.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css/bootstrap-extended.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css/colors.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css/custom.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/css/components.css') }}">
        @stack('style_ltr')
    @endif
    <style>
        @font-face {
            font-family: 'DroidArabicKufiBold';
            src: url('{{ asset('assets/fonts/DroidKufi-Bold.ttf') }}');
            font-weight: bold;
            font-style: normal;
        }

        @font-face {
            font-family: 'DroidArabicKufiRegular';
            src: url('{{ asset('assets/fonts/DroidKufi-Regular.ttf') }}');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'DroidArabicKufiRegular', Inter, ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji" !important;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row mt-2">
            <img class="mx-auto" style="max-width: 200px" src="{{ asset('logo.png') }}" alt="logo">
        </div>
    </div>
    <hr class="m-4">
    <div class="container">
        <div class="row">
            <div class="col-sm mx-auto">
                <p>
                    {!! $about !!}
                </p>
                <div class="mt-2">
                    @if (in_array(app()->getLocale(), ['en']))
                        <h3 style="color: #44546a;">Contact us:</h3>
                        <h4>You can contact us through the following communication channels:</h4>
                        <ul style="list-style-type: none; font-size: 16px;">
                            <li>Customer service in the application</li>
                            <li>Email: blockatboutique@gmail.com</li>
                            <li>Phone number: <span style="display: inline-block;">(+974 5088 8158)</span></li>
                        </ul>
                    @else
                        <h3 style="color: #44546a;">للتواصل:</h3>
                        <h4>يمكنك التواصل معنا عن طريق قنوات الاتصال التالية:</h4>
                        <ul style="list-style-type: none; font-size: 16px;">
                            <li>خدمة العملاء في التطبيق</li>
                            <li>بريدنا الالكتروني blockatboutique@gmail.com</li>
                            <li>رقم الهاتف <span style="direction: ltr; display: inline-block;">(+974 5088 8158)</span>
                            </li>
                        </ul>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <footer class="footer footer-static footer-light">
        <p class="clearfix blue-grey lighten-2 mb-0">
            <span class="float-md-left d-block d-md-inline-block mt-25">
                @if (in_array(app()->getLocale(), ['en']))
                    COPYRIGHT &copy; {{ now()->year }} All rights Reserved
                @else
                    كل حقوق النشر محفوظة &copy; {{ now()->year }}
                @endif
            </span>
            <span class="float-md-right d-none d-md-block">Hand-crafted & Made with<i
                    class="fa fa-heart pink"></i></span>
        </p>
    </footer>
</body>
</html>
