<div class="tab-pane" id="app-settings" role="tabpanel" aria-labelledby="profile-tab-justified">
    <div class="row">
    @php 
        $appSettings=json_decode(settingCollectionValue($settings,'app-version'),1);
        $freeMonth = json_decode(settingCollectionValue($settings, 'FreeMonth'), 1);
        $freePackage = json_decode(settingCollectionValue($settings, 'FreePackageId'), 1);
    @endphp
        <div class="col-12 col-sm-6">
            <label>@lang('iOS Version')</label>
            <div class="input-group mb-75">
                {{--                <div class="input-group-prepend">--}}
                {{--                    <span class="input-group-text feather icon-github" id="basic-addon9"></span>--}}
                {{--                </div>--}}
                <input type="text" class="form-control" value="{{ $appSettings['ios_app_version'] }}" name="app-version[ios_app_version]" placeholder="@lang('iOS Version')" aria-describedby="basic-addon9">
            </div>
            <label>@lang('iOS Store URL')</label>
            <div class="input-group mb-75">
                {{--                <div class="input-group-prepend">--}}
                {{--                    <span class="input-group-text feather icon-github" id="basic-addon9"></span>--}}
                {{--                </div>--}}
                <input type="url" class="form-control" value="{{ $appSettings['ios_app_url'] }}" name="app-version[ios_app_url]" placeholder="@lang('iOS Store URL')" aria-describedby="basic-addon9">
            </div>
            <label>@lang('iOS Update Message')</label>
            <div class="input-group mb-75">
                {{--                <div class="input-group-prepend">--}}
                {{--                    <span class="input-group-text feather icon-github" id="basic-addon9"></span>--}}
                {{--                </div>--}}
                <textarea class="form-control" name="app-version[ios_update_message]" placeholder="@lang('iOS Update Message')">{{ $appSettings['ios_update_message'] }}</textarea>
            </div>
            <br />
            <hr />
            <br />
            <label>@lang('Android Version')</label>
            <div class="input-group mb-75">
                {{--                <div class="input-group-prepend">--}}
                {{--                    <span class="input-group-text feather icon-github" id="basic-addon9"></span>--}}
                {{--                </div>--}}
                <input type="text" class="form-control" name="app-version[android_app_version]" value="{{ $appSettings['android_app_version'] }}" placeholder="@lang('Android Store URL')" >
            </div>
            <label>@lang('Android Store URL')</label>
            <div class="input-group mb-75">
                {{--                <div class="input-group-prepend">--}}
                {{--                    <span class="input-group-text feather icon-github" id="basic-addon9"></span>--}}
                {{--                </div>--}}
                <input type="url" class="form-control" value="{{ $appSettings['android_app_url'] }}" name="app-version[android_app_url]" placeholder="@lang('Android Version')">
            </div>
            <label>@lang('Android Update Message')</label>
            <div class="input-group mb-75">
                {{--                <div class="input-group-prepend">--}}
                {{--                    <span class="input-group-text feather icon-github" id="basic-addon9"></span>--}}
                {{--                </div>--}}
                <textarea class="form-control" name="app-version[android_update_message]" placeholder="@lang('Android Update Message')">{{ $appSettings['android_update_message'] }}</textarea>
            </div>
            <label>@lang('Subscription Setting')</label>
            <div class="input-group mb-75">
                <div class="vs-checkbox-con vs-checkbox-primary">
                    <input type="hidden" name="FreeMonth" value="0">
                    <input
                        type="checkbox"
                        name="FreeMonth"
                        value="1"
                        class="p1"
                        {{ $freeMonth ? 'checked' : '' }}
                    >
                    <span class="vs-checkbox vs-checkbox-lg">
                        <span class="vs-checkbox--check">
                            <i class="vs-icon feather icon-check"></i>
                        </span>
                    </span>
                    <span class="">First Month Free</span>
                </div>
            </div>
            <div class="input-group mb-75">
                <div class="col-12 col-sm-6 col-lg-6">
                    <label for="FreePackageId">@lang('Free Package')</label>
                    <fieldset class="form-group">
                        <select class="form-control" name="FreePackageId" id="FreePackageId">
                            @foreach (\App\Models\Package::get() as $package)
                                <option value="{{ $package->id }}" {{ $package->id == $freePackage ? 'selected' : '' }}>{{ $package->name }}</option>
                            @endforeach
                        </select>
                    </fieldset>
                </div>
            </div>
        </div>
        <div class="col-12 d-flex flex-sm-row flex-column justify-content-end mt-1">
            <button type="submit" class="btn btn-primary glow mb-1 mb-sm-0 mr-0 mr-sm-1">@lang('global.save')</button>
        </div>
    </div>
</div>
