<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Blockat">
    <meta name="keywords" content="Blockat">
    <meta name="author" content="Blockat">
    <title>@lang('global.blockat')</title>
    <link rel="apple-touch-icon" href="{{ asset('/dashboard/images/ico/apple-icon-120.png') }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('/dashboard/images/ico/favicon.ico') }}">
    <link rel="stylesheet" href="{{ asset('dashboard/css/fontawesome/css/all.css') }}"/>
    <link rel="stylesheet" media="screen" href="https://fontlibrary.org//face/droid-arabic-kufi" type="text/css"/>
    @if(in_array(app()->getLocale(), ['ar']))
    <!-- BEGIN: Theme CSS-->
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css-rtl/bootstrap.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css-rtl/bootstrap-extended.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css-rtl/colors.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css/custom.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css-rtl/components.css") }}">
        @stack('style_rtl')
    @else
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css/bootstrap.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css/bootstrap-extended.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css/colors.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css/custom.css") }}">
        <link rel="stylesheet" type="text/css" href="{{ asset("dashboard/css/components.css") }}">
        @stack('style_ltr')
    @endif
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/fontawesome.min.css" integrity="sha384-jLKHWM3JRmfMU0A5x5AkjWkw/EYfGUAGagvnfryNV3F9VqM98XiIH7VBGVoxVSc7" crossorigin="anonymous">
    <style>
        @font-face {
            font-family: 'DroidArabicKufiBold';
            src: url('{{ asset('assets/fonts/DroidKufi-Bold.ttf') }}');
            font-weight: bold;
            font-style: normal;
        }

        @font-face {
            font-family: 'DroidArabicKufiRegular';
            src: url('{{ asset('assets/fonts/DroidKufi-Regular.ttf') }}');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'DroidArabicKufiRegular', Inter, ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji" !important;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row mt-2">
            <img class="mx-auto" style="max-width: 200px" src="{{ asset('logo.png') }}" alt="logo">
        </div>
    </div>
    <hr class="m-2">
    <div class="container">
        <div class="row">
            <div class="col-sm mx-auto text-center">
                @if ($status)
                <i class="fa fa-solid fa-check fa-xl" style="font-size: 4rem; color: rgb(5, 131, 5);"></i>
                <br>
                <br>
                <p>
                    {{ app()->getLocale() == 'ar' ? 'تهانينا، لقد ربحت اشتراك شهر مجاني، يمكنك الان البدء في اضافة منتجاتك' : 'Congratulation! You have won a free month of membership. Go ahead and post your products' }}
                </p>
                <br>
                <a href="{{ url('subscription-success') }}" class="btn btn-success">{{ app()->getLocale() == 'ar' ? 'انتهاء' : 'Finish' }}</a>
                @else
                <i class="fa fa-solid fa-times fa-xl" style="font-size: 4rem; color: rgb(131, 5, 5);"></i>
                <br>
                <br>
                <p>
                    {{ app()->getLocale() == 'ar' ? 'حدث خطأ اثناء الاشتراك في باقة الشهر المجاني' : 'Error hapen while subscriping to free month' }}
                </p>
                <br>
                <a href="{{ url('subscription-failed') }}" class="btn btn-danger">{{ app()->getLocale() == 'ar' ? 'انتهاء' : 'Finish' }}</a>
                @endif
            </div>
        </div>
    </div>
    <footer class="footer footer-static footer-light text-center">
        <p class="clearfix blue-grey lighten-2 mb-0"><span class="float-md-left d-block d-md-inline-block mt-25">COPYRIGHT
                &copy; {{ now()->year }}
                All rights Reserved</span>
            <span class="float-md-right d-none d-md-block">Hand-crafted & Made with<i
                    class="fa fa-heart pink"></i></span>
        </p>
    </footer>
</body>
</html>
