@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.products')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.users_management')</a>
            </li>
            <li class="breadcrumb-item"><a href="{{ route('products.index') }}">@lang('sidebar.products')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.edit')
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <div class="form-body">
                                <div class="row mb-2">
                                    @foreach($product->images as $image)
                                    <div class="col-md-3 col-lg-3 col-6 text-center ProductImage">
                                        <div class="mb-2">
                                            {{-- <span class="badge badge-danger float-right removeProductImage" style="margin: 0 30%; position: absolute"><i class="fa fa-times"></i> </span> --}}
                                            <a href="{{ $image->full_path }}" class="mpImage">
                                                <img src="{{ $image->full_path }}" style="max-height: 200px; max-width: 200px" class="img-thumbnail rounded mx-auto d-block">
                                            </a>
                                                {{-- <input name="id" value="{{ $product->id }}" type="hidden">
                                                <input name="image_id" value="{{ $image->id }}" type="hidden"> --}}
                                            <a href="" class="btn btn-sm btn-danger mt-1 del_button" data-id="{{ $product->id }}" data-image="{{ $image->id }}">@lang('global.delete')</a>
                                        </div>

                                    </div>
                                    @endforeach
                                </div>

                                <form class="form" action="{{ route('products.update', $product->id) }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.ar_description')</label>
                                                    <textarea class="form-control" name="ar_description" placeholder="@lang('global.ar_description')">{{ old('ar_description', $product->ar_description) }}</textarea>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.en_description')</label>
                                                    <textarea class="form-control" name="en_description" placeholder="@lang('global.en_description')">{{ old('en_description', $product->en_description) }}</textarea>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.price')</label>
                                                    <input type="number" step="0.1" class="form-control price" name="price" placeholder="@lang('global.price')" value="{{ old('price', $product->price) }}" autocomplete="off">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.price_after_discount')</label>
                                                    <input type="number" step="0.1" class="form-control priceAfterDiscount" name="price_after_discount" placeholder="@lang('global.price_after_discount')" value="{{ old('price_after_discount', $product->price_after_discount) }}" autocomplete="off">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div> --}}

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.product_images')</label>
                                                    <input type="file" accept="image/*" class="form-control" name="images[]" multiple placeholder="@lang('global.ar_name')" value="{{ old('ar_name') }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.active')</label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                        <option value="1" {{ old('is_active', $product->is_active) == 1 ? "selected" : "" }}>@lang('global.active')</option>
                                                        <option value="0" {{ !is_null(old('is_active', $product->is_active)) && old('is_active', $product->is_active) == 0 ? "selected" : "" }}>@lang('global.not_active')</option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12 col-12 d-flex">
                                            <div class="col-md-6 col-6">
                                                <div class="form-group">
                                                    <div class="controls">
                                                        <label>@lang('global.category')</label>
                                                        <select class="form-control" name="category_id" id="categorySelect" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                            <option value="" {{ is_null(old('category_id')) == 1 ? "selected" : "" }}>@lang('global.select_category')</option>
                                                            @foreach($categories as $category)
                                                                <option class="level-1" value="{{ $category->id }}" {{ old('category_id', $product->category_id)  == $category->id ? "selected" : "" }}>
                                                                    {{ $category->name }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div class="help-block"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-12 text-center">
                                        <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">@lang('global.save')</button>
                                        <a href="{{ route('products.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">@lang('global.cancel')</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('style')
    <style>
        .custom-hr{
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 30px 0;
        }
        .custom-hr > span{
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }
        .removeProductImage{
            cursor: pointer;
        }
    </style>
@endpush
@push('scripts')
    <script>
        $(function (){
            setTimeout(function (){$('#categorySelect').trigger('select2:select')}, 200);

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $(input).closest('.imageDiv').find('img').attr('src', e.target.result);
                    };

                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#defaultImageInput, #defaultImageShopInput").change(function() {
                readURL(this);
            });

            $('.setDefaultImage').on('click', function (evt) {
                evt.preventDefault();
                let input = $(this).data('input')
                $("#"+input).click();
            })


            $('.removeProductImage').on('click', function (e){
                $(this).closest('.ProductImage').hide('slow', function() {this.remove();});
            })

            $('.priceAfterDiscount').on('change', function() {
                let discount = $(this).val();
                let price = $('.price').val();
                if(parseFloat(discount) >= parseFloat(price)) {
                    $(this).notify('@lang('global.price_must_lower_then')');
                    $(this).val('');
                }
            })
        });

        $(document).on('click', '.del_button', function (e) {
            e.preventDefault();
            var id = $(this).data('id');
            var image_id = $(this).data('image');

            Swal.fire({
                title: '@lang('global.are_you_sure')',
                text: '@lang('global.no_back')',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                cancelButtonText: '@lang('global.cancel')',
                confirmButtonText: '@lang('global.yes_deleted')'
                }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('delete_product_image') }}",
                        type: "DELETE",
                        data: {
                            _token: "{{ csrf_token() }}",
                            id: id,
                            image_id: image_id,
                        },
                        success: function (response) {

                            if(response.status==true) {
                                Swal.fire({
                                    icon: 'success',
                                    text: '@lang('global.deleted_successful')',
                                    confirmButtonText: '@lang('global.ok')',
                                }).then((res) => {
                                    if (res.isConfirmed) {
                                        location.reload();
                                    }
                                });
                            }
                            else {
                                Swal.fire({
                                    icon: 'warning',
                                    text: '@lang('global.At_least_one_image_is_needed')',
                                    confirmButtonText: '@lang('global.ok')',
                                }).then((res) => {
                                    if (res.isConfirmed) {
                                        location.reload();
                                    }
                                });
                            }
                        }
                    });
                }
            });
        });
    </script>
@endpush
