@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.products')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.users_management')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('products.index') }}">@lang('sidebar.products')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">@lang('global.filters')</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="{{ route("products.index") }}">
                            <div class="row">
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role">@lang('global.shop_name')</label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="user_id" id="users-list-verified">
                                            <option value="">@lang('global.all')</option>
                                            @foreach($shops as $shop)
                                                @if($shop)
                                                    <option value="{{ $shop->id }}" {{ request()->input('user_id') == $shop->id ? "selected" : "" }}>
                                                        {{ $shop->display_shop_name != '' ? $shop->display_shop_name : (App::getLocale() == 'en' ? 'Uncompleted Info' : 'المعلومات غير مكتلمة') }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role">@lang('global.category_name')</label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="category_id" id="users-list-verified">
                                            <option value="">@lang('global.all')</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" {{ request()->input('category_id') == $category->id ? "selected" : "" }}>
                                                    {{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-2 col-lg-2">
                                    <label for="users-list-role">@lang('global.price_less')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="price" value="{{ request()->input('price') }}" autocomplete="off">
                                    </fieldset>
                                </div>
                                {{-- <div class="col-12 col-sm-2 col-lg-2">
                                    <label for="users-list-role">@lang('global.price_discount_less')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="price_discount" value="{{ request()->input('price_discount') }}" autocomplete="off">
                                    </fieldset>
                                </div> --}}
                                <div class="col-12 col-sm-2 col-lg-2">
                                    <label for="users-list-verified">@lang('global.active')</label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value="">@lang('global.all')</option>
                                            <option value="1" {{ request()->input('is_active') === "1" ? "selected" : "" }}>@lang('global.active')</option>
                                            <option value="0" {{ request()->input('is_active') === "0" ? "selected" : "" }}>@lang('global.not_active')</option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> @lang('global.search')</button>
                                <a href="{{ route('products.index') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    @lang('global.clear_search')
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            @can('products_create')
                                                <div class="col-2 text-right">
                                                    <a href="{{ route('products.create') }}" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            @endcan
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.image')</th>
                                                        <th>@lang('global.shop_name')</th>
                                                        <th>@lang('global.category')</th>
                                                        <th>@lang('global.price')</th>
                                                        {{-- <th>@lang('global.price_after_discount')</th> --}}
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.approved')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @forelse($products as $product)
                                                        <tr class="text-center">
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>
                                                                <div class="pr-1">
                                                                        <span class="avatar m-0 avatar-md">
                                                                            <a href="{{ $product->default_image }}" class="mpImage">
                                                                            <img class="media-object rounded-circle" src="{{ $product->default_image }}" height="42" width="42" alt="Generic placeholder image">
                                                                            </a>
                                                                            <i></i>
                                                                        </span>
                                                                </div>
                                                            </td>
                                                            <td><a href="{{ route('shops.edit', $product->user_id) }}">{{ optional($product->shop)->display_shop_name }}</a></td>
                                                            <td>{{ optional($product->category)->name }}</td>
                                                            <td>{{ $product->price .' '.($product->price > 0 ?trans('global.qar') : '-')}}</td>
                                                            {{-- <td>{{ $product->price_after_discount .' '.($product->price_after_discount > 0 ?trans('global.qar') : '-')}}</td> --}}
                                                            <td class="is_active"><i class="fa fa-{{$product->is_active ? "check text-success" : "times text-danger"}}"></i></td>
                                                            <td class="is_approved"><i class="fa fa-{{$product->is_approved ? "check text-success" : "times text-danger"}}"></i></td>

                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    @can('products_edit')
                                                                        <a href="{{ route('products.edit', $product->id) }}" title="@lang('global.edit')" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>
                                                                        @if($product->is_active)
                                                                            <a href="#" title="@lang('global.deactivate')" data-id="{{ $product->id }}" data-route="{{ route('toggleProductStatus') }}" data-message="@lang('global.deactivate_product')" data-alt-msg="@lang('global.activate_product')" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                        @else
                                                                            <a href="#" title="@lang('global.activate')" data-id="{{ $product->id }}" data-route="{{ route('toggleProductStatus') }}" data-message="@lang('global.activate_product')" data-alt-msg="@lang('global.deactivate_product')" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                        @endif
                                                                    @endcan
                                                                    @can('products_approval')
{{--                                                                        @if($product->is_approved)--}}
                                                                            <a href="#" title="@lang('global.disapproved')" data-type="disappove" data-id="{{ $product->id }}" data-route="{{ route('toggleProductApproval') }}" data-message="@lang('global.disapprove_product')" data-alt-msg="@lang('global.approve_product')" class="btn btn-secondary  btn-sm toggleIsApprove"><i class="fas fa-eye-slash"></i></a>
{{--                                                                        @else--}}
                                                                            <a href="#" @if($product->is_approved)  disabled="" @endif  title="@lang('global.approved')" data-id="{{ $product->id }}" data-route="{{ route('toggleProductApproval') }}" data-message="@lang('global.approve_product')" data-alt-msg="@lang('global.disapprove_product')" class="btn btn-success  btn-sm toggleIsApprove"><i class="fas fa-eye"></i></a>
{{--                                                                        @endif--}}
                                                                    @endcan
                                                                    {{-- @can('products_notification')
                                                                        <a href="{{ route('notifications.index', ['type' => \App\Enums\NotificationTypesEnum::Product , 'id' => $product->id]) }}" title="@lang('global.product_use_to_notify')"  class="btn btn-info btn-sm"><i class="fas fa-sticky-note"></i></a>
                                                                    @endcan --}}
                                                                    @can('products_delete')
                                                                        <form action="{{ route('products.destroy', $product->id) }}" method="post">
                                                                            @method("delete")
                                                                            @csrf
                                                                            <button class="btn btn-sm btn-danger deleteBtnRsn" type="button" title="@lang('global.delete')"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    @endcan
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="10" class="text-center">@lang('global.no_products')</td>
                                                        </tr>
                                                    @endforelse
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.image')</th>
                                                        <th>@lang('global.shop_name')</th>
                                                        <th>@lang('global.category')</th>
                                                        <th>@lang('global.price')</th>
                                                        {{-- <th>@lang('global.price_after_discount')</th> --}}
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.approved')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $products->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>
    <div class="modal fade" id="disapproveModal" tabindex="-1" role="dialog" aria-labelledby="disapproveModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="{{ 'disapprove' }}" id="commentForm">
                    @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="commentForm">Add Comment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="comment">Comment(Ar)</label>
                        <textarea class="form-control" rows="5" name="comment" id="comment"></textarea>
                    </div>
                </div>

                    <div class="modal-body">
                        <div class="form-group">
                            <label for="comment">Comment(En)</label>
                            <textarea class="form-control" rows="5" name="comment_en" id="comment_en"></textarea>
                        </div>
                    </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-secondary" data-dismiss="modal" id="btn-submit-comment">Send</button>
                </div>
                </form>
            </div>
        </div>
    </div>

@endsection

