@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.shops')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.users_management')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('shops.index') }}">@lang('sidebar.shops')</a>
            </li>
            <li class="breadcrumb-item active">@lang('global.create')
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            @if ($errors->any())
                                @foreach ($errors->all() as $error)
                                    <div>{{$error}}</div>
                                @endforeach
                            @endif
                            <form class="form" action="{{ route('shops.store') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body">
                                    <div class="custom-hr"><span> @lang('global.manager_information')</span></div>
                                    <div class="row">
                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.name')</label>
                                                    <input type="text" class="form-control" name="name" placeholder="@lang('global.name')" value="{{ old('name') }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.country')</label>
                                                    <select class="form-control" name="country_id" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                        <option value="" {{ is_null(old('country_id')) == 1 ? "selected" : "" }}>@lang('global.select_country')</option>
                                                        @foreach($countries as $country)
                                                            <option value="{{ $country->id }}" {{ old('country_id') == $country->id ? "selected" : "" }}>
                                                                {{ $country->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <fieldset class="form-group position-relative input-divider-right">
                                                <label>@lang('global.phone')</label>
                                                <input type="text"
                                                       class="form-control"
                                                       name="phone"
                                                       placeholder="@lang('global.phone_pattern')"
                                                       value="{{ old('phone') }}"
                                                       autocomplete="off"
                                                       required="">
                                            </fieldset>
                                        </div>

                                        {{-- <div class="col-md-4 col-6">
                                            <fieldset class="form-group position-relative input-divider-right">
                                                <label>@lang('global.email')</label>
                                                <input type="email"
                                                       class="form-control"
                                                       name="email"
                                                       placeholder="@lang('global.email')"
                                                       value="{{ old('email') }}"
                                                       autocomplete="off">
                                            </fieldset>
                                        </div> --}}

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.active_status')</label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                        <option value="" {{ is_null(old('is_active')) == 1 ? "selected" : "" }}>@lang('global.select_is_active')</option>
                                                        <option value="1" {{ old('is_active') == 1 ? "selected" : "" }}>@lang('global.active')</option>
                                                        <option value="0" {{ !is_null(old('is_active')) && old('is_active') == 0 ? "selected" : "" }}>@lang('global.not_active')</option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.language')</label>
                                                    <select class="form-control" name="lang" required="" data-validation-required-message="@lang('global.this_filed_required')">
                                                        <option value="" {{ is_null(old('lang')) ? "selected" : "" }}>@lang('global.select_language')</option>
                                                        <option value="ar" {{ old('lang') == 'ar' ? "selected" : "" }}>@lang('global.arabic')</option>
                                                        <option value="en" {{ !is_null(old('lang')) && old('lang') == 'en' ? "selected" : "" }}>@lang('global.english')</option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- <div class="col-md-4 col-6">
                                            <label for="users-list-status">@lang('global.password')</label>
                                            <fieldset class="form-group">
                                                <input class="form-control" type="password" name="password" placeholder="@lang('global.password')"  required pattern=".{6,}" autocomplete="off">
                                            </fieldset>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <label for="users-list-status">@lang('global.password_confirmation')</label>
                                            <fieldset class="form-group">
                                                <input class="form-control" type="password" placeholder="@lang('global.password_confirmation')" name="password_confirmation" required pattern=".{6,}" autocomplete="off">
                                            </fieldset>
                                        </div> --}}

                                    </div>
                                    <div class="custom-hr"><span> @lang('global.shop_information')</span></div>
                                    <div class="col-12 text-center mb-1 imageDiv">
                                        <input type="file" style="display: none" name="shop_image" id="defaultImageShopInput">
                                        <img src="{{ asset('dashboard/images/logo/shop.png') }}" class="img-fluid mb-1 rounded-sm defaultShopImage" style="width: 100px" alt="user_image">
                                        <br>
                                        <button type="button" class="btn btn-primary btn-sm setDefaultImage" data-input="defaultImageShopInput">@lang('global.change_shop_image')</button>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.shop_name')</label>
                                                    <input type="text" class="form-control" name="shop_name" placeholder="@lang('global.shop_name')" value="{{ old('shop_name') }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.shop_name_en')</label>
                                                    <input type="text" class="form-control" name="shop_name_en" placeholder="@lang('global.shop_name_en')" value="{{ old('shop_name_en') }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                        <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.whatsapp')</label>
                                                    <input type="text" class="form-control" name="whatsapp" placeholder="@lang('global.whatsapp')" value="{{ old('whatsapp') }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.instagram')</label>
                                                    <input type="text" class="form-control arShopDescription" name="instagram" placeholder="@lang('global.instagram')" value="{{ old('instagram') }}">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label>@lang('global.facebook')</label>
                                                    <input type="text" class="form-control" name="facebook" placeholder="@lang('global.facebook')" value="{{ old('facebook') }}" >
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                            <div class="col-md-6 col-6">
                                                <div class="form-group">
                                                    <div class="controls">
                                                        <label>@lang('global.snapchat')</label>
                                                        <input type="text" class="form-control" name="snapchat" placeholder="@lang('global.snapchat')" value="{{ old('snapchat') }}" >
                                                        <div class="help-block"></div>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="{{ route('shops.index') }}" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('style')
    <style>
        .custom-hr{
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 30px 0;
        }
        .custom-hr > span{
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }
    </style>
@endpush
@push('scripts')
    <script>
        $(function (){
            setTimeout(() => {
                $('.shopIsSpecial').trigger('change');
            }, 900);

            $('.shopIsSpecial').on('change', function (evt){
                if($(this).find('option:selected').val() == 1) {
                    $('.specialImageDiv').removeClass('d-none');
                    $('.specialToDiv').removeClass('d-none');
                    $('.specialImageInput').prop('required', true);
                    $('.specialToInput').prop('required', true);
                    $('.arShopName').prop('required', true);
                    $('.arShopDescription').prop('required', true);
                }  else {
                    $('.specialImageDiv').addClass(' d-none');
                    $('.specialToDiv').addClass(' d-none');
                    $('.specialImageInput').prop('required', false);
                    $('.specialToInput').prop('required', false);
                    $('.arShopName').prop('required', false);
                    $('.arShopDescription').prop('required', false);
                }
            });

            $('.specialToInput').datetimepicker({
                minDate: 0,
                timepicker:false,
                format:'Y/m/d'
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $(input).closest('.imageDiv').find('img').attr('src', e.target.result);
                    };

                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#defaultImageInput, #defaultImageShopInput").change(function() {
                readURL(this);
            });

            $('.setDefaultImage').on('click', function (evt) {
                evt.preventDefault();
                let input = $(this).data('input')
                $("#"+input).click();
            })
        })
    </script>
@endpush
