@extends('dashboard.layout.main')
@section('breadcrumbs')
    <h2 class="content-header-title float-left mb-0">@lang('sidebar.shops')</h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">@lang('sidebar.dashboard')</a>
            </li>
            <li class="breadcrumb-item"><a href="#">@lang('sidebar.users_management')</a>
            </li>
            <li class="breadcrumb-item active"><a href="{{ route('shops.index') }}">@lang('sidebar.shops')</a>
            </li>
        </ol>
    </div>
@endsection
@section('content')
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">@lang('global.filters')</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="{{ route("shops.index") }}">
                            <div class="row">
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role">@lang('global.name')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="{{ request()->input('name') }}" autocomplete="off" placeholder="@lang('global.name')">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role">@lang('global.shop_name')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="shop_name" value="{{ request()->input('shop_name') }}" autocomplete="off" placeholder="@lang('global.shop_name')">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role">@lang('global.phone')</label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="phone" value="{{ request()->input('phone') }}" autocomplete="off">
                                    </fieldset>
                                </div>

                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-verified">@lang('global.active')</label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value="">@lang('global.all')</option>
                                            <option value="1" {{ request()->input('is_active') === "1" ? "selected" : "" }}>@lang('global.active')</option>
                                            <option value="0" {{ request()->input('is_active') === "0" ? "selected" : "" }}>@lang('global.not_active')</option>
                                        </select>
                                    </fieldset>
                                </div>

                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> @lang('global.search')</button>
                                <a href="{{ route('shops.index') }}" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    @lang('global.clear_search')
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            @can('shops_create')
                                                <div class="col-2 text-right">
                                                    <a href="{{ route('shops.create') }}" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            @endcan
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.image')</th>
                                                        <th>@lang('global.manager_name')</th>
                                                        <th>@lang('global.shop_name_arabic')</th>
                                                        <th>@lang('global.shop_name_english')</th>
                                                        <th>@lang('global.phone')</th>
                                                        <th>@lang('global.products_count')</th>
                                                        <th>@lang('global.active_categories_count')</th>
                                                        <th>@lang('global.phone_confirmed')</th>
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @forelse($shops as $shop)
                                                        <tr class="text-center">
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>
                                                                <div class="pr-1">
                                                                        <span class="avatar m-0 avatar-md">
                                                                            <a href="{{ $shop->default_image }}" class="mpImage">
                                                                                <img class="media-object rounded-circle" src="{{ $shop->default_image }}" height="42" width="42" alt="Generic placeholder image">
                                                                            </a>
                                                                            <i></i>
                                                                        </span>
                                                                </div>
                                                            </td>
                                                            <td>{{ $shop->name }}</td>
                                                            <td>{{ $shop->shop_name }}</td>
                                                            <td>{{ $shop->shop_name_en }}</td>
                                                            <td style="direction: ltr">{{ $shop->phone_with_code }}</td>
                                                            <td><a href="{{route('products.index',['user_id'=>$shop->id])}}">{{ $shop->products_count }}</a></td>
                                                            <td><a href="{{route('categories.index',['user_id'=>$shop->id])}}">{{ $shop->active_categories_count }}</a></td>
{{--                                                            <td>{{ $shop->active_categories_count }}</td>--}}
                                                            <td><i class="fa fa-{{$shop->phone_verified_at ? "check text-success" : "times text-danger"}}"></i></td>
                                                            <td class="is_active"><i class="fa fa-{{$shop->is_active ? "check text-success" : "times text-danger"}}"></i></td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    @can('shops_edit')
                                                                        <a href="{{ route('shops.edit', $shop->id) }}" title="@lang('global.edit')" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>
                                                                        @if($shop->is_active)
                                                                            <a href="#" title="@lang('global.deactivate')" data-id="{{ $shop->id }}" data-route="{{ route('toggleShopStatus') }}" data-message="@lang('global.deactivate_shop')" data-alt-msg="@lang('global.activate_shop')" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                        @else
                                                                            <a href="#" title="@lang('global.activate')" data-id="{{ $shop->id }}" data-route="{{ route('toggleShopStatus') }}" data-message="@lang('global.activate_shop')" data-alt-msg="@lang('global.deactivate_shop')" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                        @endif
                                                                    @endcan
                                                                    {{-- @can('shops_notification')
                                                                        <a href="{{ route('notifications.index', ['type' => \App\Enums\NotificationTypesEnum::Shop , 'id' => $shop->id]) }}" title="@lang('global.shop_use_to_notify')"  class="btn btn-info btn-sm"><i class="fas fa-sticky-note"></i></a>
                                                                    @endcan --}}
                                                                    @can('shops_delete')
                                                                        <form action="{{ route('shops.destroy', $shop->id) }}" method="post">
                                                                            @method("delete")
                                                                            @csrf
                                                                            <button class="btn btn-sm btn-danger deleteBtn" type="button" title="@lang('global.delete')"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    @endcan
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="10" class="text-center">@lang('global.no_shops')</td>
                                                        </tr>
                                                    @endforelse
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th>@lang('global.image')</th>
                                                        <th>@lang('global.manager_name')</th>
                                                        <th>@lang('global.shop_name_ar')</th>
                                                        <th>@lang('global.shop_name')</th>
                                                        <th>@lang('global.phone')</th>
                                                        <th>@lang('global.products_count')</th>
                                                        <th>@lang('global.active_categories_count')</th>
                                                        <th>@lang('global.phone_confirmed')</th>
                                                        <th>@lang('global.active')</th>
                                                        <th>@lang('global.actions')</th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                {{ $shops->appends(request()->input())->links() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

@endsection
