<?php

use App\Models\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function (){

    Route::get('user', 'Api\\UsersController@index');
    Route::get('check-auth', 'Api\\UsersController@checkAuth');
    Route::post('activeBySmsCode', 'Api\\UsersController@activeUserBySmsCode');
    Route::post('verifyEmailByCode', 'Api\\UsersController@verifyEmailByCode');
    Route::post('checkPhoneIsExists', 'Api\\UsersController@checkPhoneIsExists');
    Route::post('ChangePhoneNumber', 'Api\\UsersController@ChangePhoneNumber');
    Route::post('resendVerificationCode', 'Api\\UsersController@resendVerificationCode');
    Route::get('vendorAcceptContract', 'Api\\UsersController@VendorAcceptContract');
    Route::post('updateUserProfile', 'Api\\UsersController@updateUserProfile');
    Route::post('switchProfileType', 'Api\\UsersController@switchUserType');
    Route::delete('user-delete', 'Api\\UsersController@destroy');
    Route::get('logout', 'Api\\AuthController@logout');

    Route::get('favorites', 'Api\\FavoritesController@index');
    Route::post('favorites', 'Api\\FavoritesController@storeOrDelete');

    Route::post('categoryPackages', 'Api\\PaymentsController@categoryPackages');
    Route::post('checkMarketCode', 'Api\\PaymentsController@checkMarketCode');
    Route::post('initialSubscription', 'Api\\PaymentsController@initialSubscription');
    Route::get('subscribe-page/{payment_id}', 'Api\\PaymentsController@showPaymentPage');
//    Route::post('paymentStatus', 'Api\\PaymentsController@paymentStatus');

    // Free month Subscription
    Route::get('free-month/{pay_id}', 'Api\\PaymentsController@freeMonth');

    Route::get('getMySubscriptions', 'Api\\PaymentsController@getMySubscriptions');

    Route::post('createProduct', 'Api\\ProductsController@store');
    Route::post('updateProduct', 'Api\\ProductsController@updateProduct');
    Route::post('myProducts', 'Api\\ProductsController@myProducts');
    Route::post('toggleProductStatus', 'Api\\ProductsController@toggleProductStatus');

    Route::get('getNotifications', 'Api\\NotificationsController@index');
    Route::post('deleteNotification', 'Api\\NotificationsController@deleteNotification');

});

Route::middleware('api')->group(function (){
    Route::post('version-check', 'Api\\VersionController@index');
    Route::get('categories', 'Api\\CategoriesController@index');
//    Route::get('category/{id}', 'Api\\CategoriesController@show');

    Route::get('shops', 'Api\\CategoriesController@categoryShops');
    Route::get('ShopProducts', 'Api\\CategoriesController@ShopProducts');

    Route::get('products', 'Api\\ProductsController@showProduct');
//    Route::get('products/{id}', 'Api\\ProductsController@show');

    Route::get('countries', 'Api\\CountriesController@index');

//    Route::post('resetPassword', 'Api\\UsersController@resetPassword');
//    Route::post('sendResetPasswordCode', 'Api\\UsersController@sendResetPasswordCode');
    Route::post('masterData', 'Api\\MasterDataController@masterData');

    Route::post('contactUs', 'Api\\ContactUsController@contactUs');

    Route::get('about', 'Api\\MasterDataController@about');

    Route::post('saveStdOut', 'Api\\ContactUsController@test');
});


require __DIR__.'/api_auth.php';
