<?php

use Illuminate\Support\Facades\Route;

Route::prefix('dashboard')
    ->namespace('Dashboard')
    ->middleware(['auth:admins'])
    ->group(function (){
        Route::get('/home' ,'HomeController@index')->name('dashboard.home');

        Route::get('changeLang', 'HomeController@changeLang')->name('dashboard.changeLang');
        Route::get('/logout' , 'LoginController@destroy')->name('dashboard.logout');

        Route::resource('/roles' ,'RolesController');
        Route::resource('/admins' ,'AdminsController');
        Route::post('toggleAdminStatus', 'AdminsController@toggleAdminStatus')->name('toggleAdminStatus');

        Route::resource('countries', 'CountriesController');
        Route::post('toggleCountryStatus', 'CountriesController@toggleCountryStatus')->name('toggleCountryStatus');

        Route::resource('categories', 'CategoriesController');
        Route::post('toggleCategoryStatus', 'CategoriesController@toggleCategoryStatus')->name('toggleCategoryStatus');
        Route::post('reorder-categories', "CategoriesController@reorderCategories")->name('reorderCategories');

        Route::resource('packages', 'PackagesController');
        Route::post('togglePackagesStatus', 'PackagesController@togglePackagesStatus')->name('togglePackagesStatus');

        Route::resource('shops' , 'ShopsController');
        Route::post('toggleShopStatus', 'ShopsController@toggleShopStatus')->name('toggleShopStatus');

        Route::resource('users' , 'UsersController');
        Route::post('toggleUserStatus', 'UsersController@toggleUserStatus')->name('toggleUserStatus');

        Route::resource('products' , 'ProductsController');
        Route::delete('delete_product_image', 'ProductsController@destroyImage')->name('delete_product_image');
        Route::post('toggleProductStatus', 'ProductsController@toggleProductStatus')->name('toggleProductStatus');
        Route::post('toggleProductApproval', 'ProductsController@toggleProductApproval')->name('toggleProductApproval');
        Route::post('product-disapprove', 'ProductsController@disapproveProduct')->name('disapprove');

        Route::get('payment_subscription' , 'PaymentSubscriptionController')->name('payment_subscription');
        Route::get('payment_subscription/{id}' , 'PaymentSubscriptionController@getSingle')->name('payment_subscription.single');
        Route::post('payment_subscription_update_status' , 'PaymentSubscriptionController@updatePaymentStatus')->name('payment_subscription.status');

        // Route::resource('subscriptions' , 'SubscriptionsController');
        // Route::resource('payment_transactions' , 'PaymentTransactionsController');

        Route::resource('complaints' , 'ComplaintsController');

        Route::resource('notifications','NotificationsController');
        Route::resource('settings' , 'SettingsController');
        Route::resource('marketer' , 'MarketerController');
        Route::post('marketer/subscription/export/{marketer_id}' , 'MarketerController@export')->name('export');
        Route::post('getMarketerCode' , 'MarketerController@getMarketerCode')->name('getMarketerCode');
        Route::get('search_subscriber' , 'MarketerController@searchSubscriber')->name('searchSubscriber');


    });

Route::prefix('dashboard')
    ->namespace('Dashboard')->group(function (){
        Route::get('/login' , 'LoginController@index')->name('dashboard.loginView');
        Route::get(HashIdObj()->encode(1000) , 'LoginController@index')->name('dashboard.loginView');
        Route::post('/login' , 'LoginController@store')->name('dashboard.login');
    });
