<?php

use App\Models\ShopCategory;
use Carbon\Carbon;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('api', function (){
    return redirect()->away('https://documenter.getpostman.com/view/6039170/TzXtHzix');
});

Route::get('/', function () {
    return view('welcome');
})->name('home');

Route::get('privacy-policy', function (){
    return view('privacyPolicy');
});
//Route::get('purchase', [\App\Http\Controllers\Dashboard\HomeController::class,'purchaseSample']);
Route::get('/{lang}/pay-now/{pay_id}', [\App\Http\Controllers\Api\PaymentsController::class,'showPaymentPage'])->name('pay-now.show');
Route::post('sadad-purchased/{order_id}', [\App\Http\Controllers\Api\PaymentsController::class,'paymentStatus']);

Route::get('share/{product_id}', function ($product_id) {
    $product = \App\Models\Product::query()
        ->where('id', HashIdObj()->decode($product_id))
        ->firstOrFail();
    return view('share', ['product' => $product]);
});

require __DIR__.'/auth.php';
require __DIR__.'/dashboard.php';

