<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.users'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.users_management'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('users.index')); ?>"><?php echo app('translator')->get('sidebar.users'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="<?php echo e(route("users.index")); ?>">
                            <div class="row">
                                <div class="col-12 col-sm-4 col-lg-4">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.name'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="<?php echo e(request()->input('name')); ?>" autocomplete="off" placeholder="<?php echo app('translator')->get('global.name'); ?>">
                                    </fieldset>
                                </div>

                                <div class="col-12 col-sm-4 col-lg-4">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.phone'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="phone" value="<?php echo e(request()->input('phone')); ?>" autocomplete="off">
                                    </fieldset>
                                </div>

                                <div class="col-12 col-sm-4 col-lg-4">
                                    <label for="users-list-verified"><?php echo app('translator')->get('global.active'); ?></label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                            <option value="1" <?php echo e(request()->input('is_active') === "1" ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                            <option value="0" <?php echo e(request()->input('is_active') === "0" ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('global.search'); ?></button>
                                <a href="<?php echo e(route('users.index')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    <?php echo app('translator')->get('global.clear_search'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users_create')): ?>
                                                <div class="col-2 text-right">
                                                    <a href="<?php echo e(route('users.create')); ?>" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone_confirmed'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                            <tr class="text-center">
                                                                <td><?php echo e($loop->iteration); ?></td>
                                                                <td>
                                                                    <div class="pr-1">
                                                                        <span class="avatar m-0 avatar-md">
                                                                            <a href="<?php echo e($user->default_image); ?>" class="mpImage">
                                                                                <img class="media-object rounded-circle" src="<?php echo e($user->default_image); ?>" height="42" width="42" alt="Generic placeholder image">
                                                                            </a>
                                                                            <i></i>
                                                                        </span>
                                                                    </div>
                                                                </td>
                                                                <td><?php echo e($user->name); ?></td>
                                                                <td><?php echo e($user->phone); ?></td>
                                                                <td><i class="fa fa-<?php echo e($user->phone_verified_at ? "check text-success" : "times text-danger"); ?>"></i></td>
                                                                <td class="is_active"><i class="fa fa-<?php echo e($user->is_active ? "check text-success" : "times text-danger"); ?>"></i></td>
                                                                <td>
                                                                    <div class="d-inline-flex action-btn">
                                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users_edit')): ?>
                                                                            <a href="<?php echo e(route('users.edit', $user->id)); ?>" title="<?php echo app('translator')->get('global.edit'); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>
                                                                            <?php if($user->is_active): ?>
                                                                                <a href="#" title="<?php echo app('translator')->get('global.deactivate'); ?>" data-id="<?php echo e($user->id); ?>" data-route="<?php echo e(route('toggleUserStatus')); ?>" data-message="<?php echo app('translator')->get('global.deactivate_user'); ?>" data-alt-msg="<?php echo app('translator')->get('global.activate_user'); ?>" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                            <?php else: ?>
                                                                                <a href="#" title="<?php echo app('translator')->get('global.activate'); ?>" data-id="<?php echo e($user->id); ?>" data-route="<?php echo e(route('toggleUserStatus')); ?>" data-message="<?php echo app('translator')->get('global.activate_user'); ?>" data-alt-msg="<?php echo app('translator')->get('global.deactivate_user'); ?>" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                            <?php endif; ?>
                                                                        <?php endif; ?>
                                                                         <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users_delete')): ?>
                                                                            <form action="<?php echo e(route('users.destroy', $user->id)); ?>" method="post">
                                                                                <?php echo method_field("delete"); ?>
                                                                                <?php echo csrf_field(); ?>
                                                                                <button class="btn btn-sm btn-danger deleteBtn" type="button" title="<?php echo app('translator')->get('global.delete'); ?>"><i class="fas fa-trash"></i></button>
                                                                            </form>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                            <tr>
                                                                <td colspan="10" class="text-center"><?php echo app('translator')->get('global.no_users'); ?></td>
                                                            </tr>
                                                        <?php endif; ?>
                                                        <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone_confirmed'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($users->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/users-management/users/index.blade.php ENDPATH**/ ?>