
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <title><?php echo app('translator')->get('global.blockat_login_title'); ?></title>
    <meta charset="utf-8">
    <!-- IE Compatibility Meta -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- First Mobile Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="apple-touch-icon" href="<?php echo e(asset("dashboard/images/ico/apple-touch-icon.png")); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset("dashboard/images/ico/favicon.ico")); ?>">
    <link href="https://fonts.googleapis.com/css?family=Changa:200,400,500,600,700&subset=arabic" rel="stylesheet">
    <link href="<?php echo e(asset("dashboard/css-rtl/bootstrap.min.css")); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dashboard/css-rtl/login-page.css')); ?>" rel="stylesheet" />


</head>

<body>
<div class="overlay" style="    position: absolute;
    left: 0;
    top: 0;
    right: 0;
    bottom: 0;
    width: 100%;
    height: 100%;
    color: #FFF;
"></div>
<div class="container">
    <div class="headd">
        <div class="col-lg-12 col-xs-12 text-center logo" style="display:block; ">
            <a class="float-shadow" href="#" title="Blockat">
                <img src="<?php echo e(asset('dashboard/images/logo/logo-big.png')); ?>" title="Blockat" style="margin-top: 20px ; opacity: 1" alt="Mazadat" class="img-responsive img-fluid center-block" /></a>
        </div>
    </div>




    <div class="clearfix"></div>
    <h3 class="headline" style="position: relative; color: #0a0a0a"><span></span></h3>

    <?php if($errors->has('phone')): ?>
        <div class="row justify-content-center">
            <div class="col-6">
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong><?php echo e($errors->first('phone')); ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="logg col-12 d-flex justify-content-center">
        <form class="form-group" method="post" action="<?php echo e(route('dashboard.login')); ?>"  >
            <?php echo csrf_field(); ?>

            <input class="phoneInput" type="text" name="phone" value="<?php echo e(old('phone')); ?>"  placeholder="<?php echo app('translator')->get('global.phone_admin'); ?>" autocomplete="off" autofocus style="text-align: center" required>

            <input type="password" name="password" required placeholder="<?php echo app('translator')->get('global.password'); ?>" style="text-align: center">

            <input type="submit" value="<?php echo app('translator')->get("global.login"); ?>">
        </form>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-backstretch/2.1.18/jquery.backstretch.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js"></script>

<script>
    $(document).ready (function(){
        if("<?php echo e($errors->has('phone')); ?>")
        {
            $("#alert").hide();
            $("#alert").fadeTo(7000, 900).slideUp(900, function(){
                $("#alert").slideUp(900);
            });

        }
    });
    $('body').backstretch([
        "images/logo/db.jpg",
        "images/logo/db1.jpg",
        "images/logo/db2.jpg",
    ], {
        fade: 800,
        duration: 5000
    });

</script>

</body>

</html>
<?php /**PATH /var/www/html/Blockat/resources/views/dashboard/auth/login.blade.php ENDPATH**/ ?>