<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.complaints_management'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('complaints.index')); ?>"><?php echo app('translator')->get('global.complaints'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="#">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.name'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="<?php echo e(request()->input('name')); ?>" autocomplete="off">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-status"><?php echo app('translator')->get('global.phone'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="phone" value="<?php echo e(request()->input('phone')); ?>" autocomplete="off" type="number">
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('global.search'); ?></button>
                                <a href="<?php echo e(route('complaints.index')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    <?php echo app('translator')->get('global.clear_search'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone'); ?></th>
                                                        <th><?php echo app('translator')->get('global.message'); ?></th>
                                                        <th><?php echo app('translator')->get('global.created_at'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__empty_1 = true; $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                            <tr class="text-center">
                                                                <td><?php echo e($loop->iteration); ?></td>
                                                                <td data-toggle="tooltip" data-placement="bottom" title="<?php echo e($complaint->created_at); ?>">
                                                                    <?php echo e($complaint->name); ?>

                                                                </td>
                                                                <td><?php echo e($complaint->phone); ?></td>
                                                                <td><?php echo e($complaint->message); ?></td>
                                                                <td><?php echo e(optional($complaint->created_at)->diffForHumans() .' / '. optional($complaint->created_at)->format('Y-m-d')); ?></td>
                                                                <td>
                                                                    <div class="d-inline-flex action-btn">
                                                                        <button type="button" title="<?php echo app('translator')->get('global.view'); ?>" data-id="<?php echo e($complaint->message); ?>" data-toggle="modal" data-target="#showComplaint" class="btn btn-primary btn-sm mr-2"><i class="fa fa-eye"></i></button>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                            <tr>
                                                                <td colspan="7" class="text-center"><?php echo app('translator')->get('global.no_complaints'); ?></td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone'); ?></th>
                                                        <th><?php echo app('translator')->get('global.created_at'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($complaints->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

    <?php echo $__env->make('dashboard.complaints_management.complaints.modals.showComplaint', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(function() {
            $('#showComplaint').on('show.bs.modal' , function (e) {
                let id = $(e.relatedTarget).data('id');
                $('.clearShowInfo').html('');
                $('.description').html(id);
            });


        })
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .vertical-line{
            display: inline-block;
            border-left: 1px solid #f34b4b;
            margin: 0 10px;
            height: 125px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/complaints_management/complaints/index.blade.php ENDPATH**/ ?>