<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.admins'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('admins.index')); ?>"><?php echo app('translator')->get('sidebar.admins'); ?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo app('translator')->get('global.create'); ?>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="<?php echo e(route('admins.store')); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="col-12 text-center mb-1">
                                        <input type="file" style="display: none" name="image" id="defaultImageInput">
                                        <img src="<?php echo e(asset('dashboard/images/logo/user.jpg')); ?>" class="img-fluid mb-1 rounded-sm defaultImage" style="width: 100px" alt="user_image">
                                        <br>
                                        <button type="button" class="btn btn-primary btn-sm setDefaultImage"><?php echo app('translator')->get('global.change_user_image'); ?></button>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.name'); ?></label>
                                                    <input autocomplete="off" type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('global.name'); ?>" value="<?php echo e(old('name')); ?>" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <label for="users-list-status"><?php echo app('translator')->get('global.password'); ?></label>
                                            <fieldset class="form-group">
                                                <input class="form-control" type="password" name="password" placeholder="<?php echo app('translator')->get('global.password'); ?>"  required pattern=".{6,}" autocomplete="off">
                                            </fieldset>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <label for="users-list-status"><?php echo app('translator')->get('global.password_confirmation'); ?></label>
                                            <fieldset class="form-group">
                                                <input class="form-control" type="password" placeholder="<?php echo app('translator')->get('global.password_confirmation'); ?>" name="password_confirmation" required pattern=".{6,}" autocomplete="off">
                                            </fieldset>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <fieldset class="form-group position-relative input-divider-right">
                                                <label><?php echo app('translator')->get('global.phone'); ?></label>
                                                <input type="text"
                                                       class="form-control"
                                                       name="phone"
                                                       placeholder="<?php echo app('translator')->get('global.phone_pattern'); ?>"
                                                       value="<?php echo e(old('phone')); ?>"
                                                       autocomplete="off"
                                                       required="">
                                            </fieldset>
                                        </div>
                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.active'); ?></label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="" <?php echo e(is_null(old('is_active')) == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.select_is_active'); ?></option>
                                                        <option value="1" <?php echo e(old('is_active') == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                                        <option value="0" <?php echo e(!is_null(old('is_active')) && old('is_active') == 0 ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.roles'); ?></label>
                                                    <select class="form-control" name="role_id" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="" <?php echo e(is_null(old('role_id')) == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.select_role'); ?></option>
                                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($role->id); ?>" <?php echo e(old('role_id') == $role->id ? "selected" : ""); ?>><?php echo e(getRoleName($role)); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="<?php echo e(route('admins.index')); ?>" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('.defaultImage').attr('src', e.target.result);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#defaultImageInput").change(function() {
            readURL(this);
        });

        $('.setDefaultImage').on('click', function (evt) {
            evt.preventDefault();
            $("#defaultImageInput").click();
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/administrator/admins/create.blade.php ENDPATH**/ ?>