<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.users'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.users_management'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('users.index')); ?>"><?php echo app('translator')->get('sidebar.users'); ?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo app('translator')->get('global.edit'); ?>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="<?php echo e(route('users.update', $user->id)); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="form-body">
                                    <div class="col-12 text-center mb-1 imageDiv">
                                        <input type="file" style="display: none" name="shop_image" id="defaultImageInput">
                                        <img src="<?php echo e($user->default_image); ?>" class="img-fluid mb-1 rounded-sm defaultImage" style="width: 100px" alt="user_image">
                                        <br>
                                        <button type="button" class="btn btn-primary btn-sm setDefaultImage" data-input="defaultImageInput"><?php echo app('translator')->get('global.change_user_image'); ?></button>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.name'); ?></label>
                                                    <input type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('global.name'); ?>" value="<?php echo e(old('name', $user->name)); ?>" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.country'); ?></label>
                                                    <select class="form-control citySelect" name="country_id" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($country->id); ?>" <?php echo e(old('country_id', $user->country_id) == $country->id ? "selected" : ""); ?>>
                                                                <?php echo e($country->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <fieldset class="form-group position-relative input-divider-right">
                                                <label><?php echo app('translator')->get('global.phone'); ?></label>
                                                <input type="text"
                                                       class="form-control"
                                                       name="phone"
                                                       placeholder="<?php echo app('translator')->get('global.phone_pattern'); ?>"
                                                       value="<?php echo e(old('phone', $user->phone)); ?>"
                                                       autocomplete="off"
                                                       required="">
                                            </fieldset>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <fieldset class="form-group position-relative input-divider-right">
                                                <label><?php echo app('translator')->get('global.email'); ?></label>
                                                <input type="email"
                                                       class="form-control"
                                                       name="email"
                                                       placeholder="<?php echo app('translator')->get('global.email'); ?>"
                                                       value="<?php echo e(old('email', $user->email)); ?>"
                                                       autocomplete="off">
                                            </fieldset>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.active'); ?></label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="1" <?php echo e(old('is_active', $user->is_active) == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                                        <option value="0" <?php echo e(!is_null(old('is_active', $user->is_active)) && old('is_active', $user->is_active) == 0 ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.language'); ?></label>
                                                    <select class="form-control" name="lang" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="ar" <?php echo e(old('lang', $user->lang) == 'ar' ? "selected" : ""); ?>><?php echo app('translator')->get('global.arabic'); ?></option>
                                                        <option value="en" <?php echo e(!is_null(old('lang', $user->lang)) && old('lang', $user->lang) == 'en' ? "selected" : ""); ?>><?php echo app('translator')->get('global.english'); ?></option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="<?php echo e(route('users.index')); ?>" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .custom-hr{
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 30px 0;
        }
        .custom-hr > span{
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(function (){

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $(input).closest('.imageDiv').find('img').attr('src', e.target.result);
                    };

                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#defaultImageInput, #defaultImageShopInput").change(function() {
                readURL(this);
            });

            $('.setDefaultImage').on('click', function (evt) {
                evt.preventDefault();
                let input = $(this).data('input')
                $("#"+input).click();
            })
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/users-management/users/edit.blade.php ENDPATH**/ ?>