<?php $__env->startSection('breadcrumbs'); ?>
<h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.financial_management'); ?></h2>
<div class="breadcrumb-wrapper col-12">
    <ol class="breadcrumb">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
        </li>
        <li class="breadcrumb-item">
            <a href="#"><?php echo app('translator')->get('sidebar.financial_management'); ?></a>
        </li>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('payment_subscription')); ?>"><?php echo app('translator')->get('global.subscriptions'); ?></a>
        </li>
    </ol>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="users-list-wrapper">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                </ul>
            </div>
        </div>
        <div class="card-content collapse show">
            <div class="card-body">
                <div class="users-list-filter">
                    <form action="#">
                        <div class="row">
                            <div class="col-12 col-sm-6 col-lg-3">
                                <label for="users-list-role"><?php echo app('translator')->get('global.shop_name'); ?></label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="user_id" id="users-list-verified">
                                        <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                        <?php $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($shop): ?>
                                        <option value="<?php echo e($shop->id); ?>"
                                            <?php echo e(request()->input('user_id') == $shop->id ? "selected" : ""); ?>>
                                            <?php echo e($shop->display_shop_name); ?></option>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-3">
                                <label for="users-list-role"><?php echo app('translator')->get('global.category_name'); ?></label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="category_id" id="users-list-verified">
                                        <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($shop)): ?>
                                        <option value="<?php echo e($category->id); ?>"
                                            <?php echo e(request()->input('category_id') == $category->id ? "selected" : ""); ?>>
                                            <?php echo e($category->name); ?></option>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified"><?php echo app('translator')->get('global.payment_id'); ?></label>
                                <fieldset class="form-group">
                                    <input type="text" class="form-control" name="payment_id"
                                        value="<?php echo e(request()->input('payment_id')); ?>"
                                        placeholder="<?php echo app('translator')->get('global.payment_id'); ?>" autocomplete="off">
                                    <div class="help-block"></div>
                                </fieldset>
                            </div>

                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified"><?php echo app('translator')->get('global.date'); ?></label>
                                <fieldset class="form-group">
                                    <input type="date" class="form-control" name="date"
                                        value="<?php echo e(request()->input('date')); ?>"
                                        placeholder="<?php echo app('translator')->get('global.date'); ?>">
                                    <div class="help-block"></div>
                                </fieldset>
                            </div>
                            <div class="col-12 col-sm-6 col-lg-2">
                                <label for="users-list-verified"><?php echo app('translator')->get('global.status'); ?></label>
                                <fieldset class="form-group">
                                    <select class="form-control" name="status" id="users-list-verified">
                                        <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                        <option value="SUCCESS"
                                            <?php echo e(request()->input('status') === "SUCCESS" ? "selected" : ""); ?>>
                                            <?php echo app('translator')->get('global.success'); ?></option>
                                        <option value="PENDING"
                                            <?php echo e(request()->input('status') === "PENDING" ? "selected" : ""); ?>>
                                            <?php echo app('translator')->get('global.pending'); ?></option>
                                        <option value="PROCCESSING"
                                            <?php echo e(request()->input('status') === "PROCCESSING" ? "selected" : ""); ?>>
                                            <?php echo app('translator')->get('global.processing'); ?></option>
                                        <option value="FAILED"
                                            <?php echo e(request()->input('status') === "FAILED" ? "selected" : ""); ?>>
                                            <?php echo app('translator')->get('global.failed'); ?></option>
                                    </select>
                                </fieldset>
                            </div>
                        </div>
                        <div class="d-flex justify-content-center">
                            <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i>
                                <?php echo app('translator')->get('global.search'); ?></button>
                            <a href="<?php echo e(route('payment_subscription')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                <?php echo app('translator')->get('global.clear_search'); ?>
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"></h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li>
                        <a data-action="collapse"><i class="feather icon-chevron-down"></i></a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="card-content collapse show">
            <div class="card-body">
                <section id="column-selectors">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-content">
                                    <div class="card-body card-dashboard">
                                        <div class="table-responsive">
                                            <table class="table table-striped datatableInit nowrap">
                                                <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        
                                                        <th><?php echo app('translator')->get('global.payment_id'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.created_at'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.start_date'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.end_date'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.shop_name_english'); ?></th>
                                                        <th><?php echo app('translator')->get('global.shop_name_arabic'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.category_name'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.price'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.status'); ?></th>
                                                        
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr class="text-center">
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        
                                                        <td><?php echo e($subscription->payment_id); ?></td>
                                                        
                                                        <td><?php echo e(optional($subscription->payment)->created_at); ?></td>
                                                        
                                                        <td><?php echo e($subscription->valid_from); ?></td>
                                                        
                                                        <td><?php echo e($subscription->valid_to); ?></td>
                                                        
                                                        <td><?php echo e(optional($subscription->shop)->shop_name_en); ?></td>
                                                        <td><?php echo e(optional($subscription->shop)->shop_name); ?></td>
                                                        
                                                        <td><?php echo e(optional($subscription->category)->name); ?></td>
                                                        
                                                        <td><?php echo e(optional($subscription->payment)->amount); ?></td>
                                                        
                                                        <td><?php echo e(optional($subscription->payment)->status); ?></td>
                                                        
                                                        <td>
                                                            <a href="<?php echo e(route('payment_subscription.single', $subscription->id)); ?>" class="btn btn-info btn-sm">
                                                                <i class="fa fa-ellipsis-h"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="8" class="text-center">
                                                            <?php echo app('translator')->get('global.no_payment_transactions'); ?></td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                                <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        
                                                        <th><?php echo app('translator')->get('global.payment_id'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.shop_name'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.category_name'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.package_name'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.auto_renew'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.status'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.package_days'); ?></th>
                                                        
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                        <div class="pagination">
                                            <?php echo e($subscriptions->appends(request()->input())->links()); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $(function () {
        $('#showInfo').on('show.bs.modal', function (e) {
            let info = $(e.relatedTarget).data('info');
            $('.clearShowInfo').html('');
            $('.username').html(info.user ? info.user.name : '');
            $('.accountName').html(info.account_name);
            $('.accountNumber').html(info.account_number);
            $('.amount').html(info.amount + " <?php echo app('translator')->get('global.sar'); ?>");
            $('.ibanNumber').html(info.iban_number);
            $('.isExported').html(info.is_exported);
            $('.createdAt').html(info.created_at);
        });

        $('#changeStatus').on('show.bs.modal', function (e) {
            let id = $(e.relatedTarget).data('id');
            $('#withdrawalId').val(id);
        });

    })

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/financial-management/payment_subscriptions/index.blade.php ENDPATH**/ ?>