<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.admins'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('admins.index')); ?>"><?php echo app('translator')->get('sidebar.admins'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="#">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.name'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="<?php echo e(request()->input('name')); ?>" autocomplete="off">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-status"><?php echo app('translator')->get('global.phone_admin'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="phone" value="<?php echo e(request()->input('phone')); ?>" autocomplete="off" type="number">
                                    </fieldset>
                                </div>

                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-status"><?php echo app('translator')->get('global.is_active'); ?></label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active">
                                            <option value=""><?php echo app('translator')->get('global.select_is_active'); ?></option>
                                            <option value="1" <?php echo e(request()->input('is_active') == 1 ? 'selected' : ''); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                            <option value="0" <?php echo e(!is_null(request()->input('is_active')) && request()->input('is_active') == 0 ? 'selected' : ''); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('global.search'); ?></button>
                                <a href="<?php echo e(route('admins.index')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    <?php echo app('translator')->get('global.clear_search'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admins_create')): ?>
                                                <div class="col-2 text-right">
                                                    <a href="<?php echo e(route('admins.create')); ?>" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone_admin'); ?></th>
                                                        <th><?php echo app('translator')->get('global.is_active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr class="text-center">
                                                            <td><?php echo e($loop->iteration); ?></td>
                                                            <td>
                                                                <div class="pr-1">
                                                                        <span class="avatar m-0 avatar-md"><img class="media-object rounded-circle" src="<?php echo e($admin->logo); ?>" height="42" width="42" alt="Generic placeholder image">
                                                                            <i></i>
                                                                        </span>
                                                                </div>
                                                            </td>
                                                            <td><?php echo e($admin->name); ?></td>

                                                            <td><?php echo e($admin->phone); ?></td>
                                                            <td><?php echo isActiveHtml($admin->is_active); ?></td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admins_edit')): ?>
                                                                        <a href="<?php echo e(route('admins.edit', HashIdObj()->encode($admin->id))); ?>" title="<?php echo app('translator')->get('global.edit'); ?>" class="btn btn-primary btn-sm ml-1"><i class="fa fa-edit"></i></a>
                                                                        <?php if($admin->is_active): ?>
                                                                            <a href="#" title="<?php echo app('translator')->get('global.deactivate'); ?>" data-id="<?php echo e($admin->id); ?>" data-route="<?php echo e(route('toggleAdminStatus')); ?>" data-message="<?php echo app('translator')->get('global.deactivate_admin'); ?>" data-alt-msg="<?php echo app('translator')->get('global.activate_admin'); ?>" class="btn btn-dark ml-1 btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                        <?php else: ?>
                                                                            <a href="#" title="<?php echo app('translator')->get('global.activate'); ?>" data-id="<?php echo e($admin->id); ?>" data-route="<?php echo e(route('toggleAdminStatus')); ?>" data-message="<?php echo app('translator')->get('global.activate_admin'); ?>" data-alt-msg="<?php echo app('translator')->get('global.deactivate_admin'); ?>" class="btn btn-success ml-1 btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admins_delete')): ?>
                                                                        <form action="<?php echo e(route('admins.destroy', $admin->id)); ?>" method="post">
                                                                            <?php echo method_field("delete"); ?>
                                                                            <?php echo csrf_field(); ?>
                                                                            <button class="btn btn-sm btn-danger ml-1 deleteBtn" type="button" title="<?php echo app('translator')->get('global.delete'); ?>"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    <?php endif; ?>

                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="7" class="text-center"><?php echo app('translator')->get('global.no_admins'); ?></td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone_admin'); ?></th>
                                                        <th><?php echo app('translator')->get('global.is_active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($admins->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/administrator/admins/index.blade.php ENDPATH**/ ?>