<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.products'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.users_management'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('products.index')); ?>"><?php echo app('translator')->get('sidebar.products'); ?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo app('translator')->get('global.edit'); ?>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <div class="form-body">
                                <div class="row mb-2">
                                    <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-3 col-lg-3 col-6 text-center ProductImage">
                                        <div class="mb-2">
                                            
                                            <a href="<?php echo e($image->full_path); ?>" class="mpImage">
                                                <img src="<?php echo e($image->full_path); ?>" style="max-height: 200px; max-width: 200px" class="img-thumbnail rounded mx-auto d-block">
                                            </a>
                                                
                                            <a href="" class="btn btn-sm btn-danger mt-1 del_button" data-id="<?php echo e($product->id); ?>" data-image="<?php echo e($image->id); ?>"><?php echo app('translator')->get('global.delete'); ?></a>
                                        </div>

                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <form class="form" action="<?php echo e(route('products.update', $product->id)); ?>" method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.ar_description'); ?></label>
                                                    <textarea required class="form-control" name="ar_description" placeholder="<?php echo app('translator')->get('global.ar_description'); ?>"><?php echo e(old('ar_description', $product->ar_description)); ?></textarea>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.en_description'); ?></label>
                                                    <textarea required class="form-control" name="en_description" placeholder="<?php echo app('translator')->get('global.en_description'); ?>"><?php echo e(old('en_description', $product->en_description)); ?></textarea>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.price'); ?></label>
                                                    <input type="number" step="0.1" class="form-control price" name="price" placeholder="<?php echo app('translator')->get('global.price'); ?>" value="<?php echo e(old('price', $product->price)); ?>" autocomplete="off">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.product_images'); ?></label>
                                                    <input type="file" accept="image/*" class="form-control" name="images[]" multiple placeholder="<?php echo app('translator')->get('global.ar_name'); ?>" value="<?php echo e(old('ar_name')); ?>">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.active'); ?></label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="1" <?php echo e(old('is_active', $product->is_active) == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                                        <option value="0" <?php echo e(!is_null(old('is_active', $product->is_active)) && old('is_active', $product->is_active) == 0 ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12 col-12 d-flex">
                                            <div class="col-md-6 col-6">
                                                <div class="form-group">
                                                    <div class="controls">
                                                        <label><?php echo app('translator')->get('global.category'); ?></label>
                                                        <select class="form-control" name="category_id" id="categorySelect" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                            <option value="" <?php echo e(is_null(old('category_id')) == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.select_category'); ?></option>
                                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option class="level-1" value="<?php echo e($category->id); ?>" <?php echo e(old('category_id', $product->category_id)  == $category->id ? "selected" : ""); ?>>
                                                                    <?php echo e($category->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <div class="help-block"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-12 text-center">
                                        <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn"><?php echo app('translator')->get('global.save'); ?></button>
                                        <a href="<?php echo e(route('products.index')); ?>" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light"><?php echo app('translator')->get('global.cancel'); ?></a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .custom-hr{
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 30px 0;
        }
        .custom-hr > span{
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }
        .removeProductImage{
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(function (){
            setTimeout(function (){$('#categorySelect').trigger('select2:select')}, 200);

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $(input).closest('.imageDiv').find('img').attr('src', e.target.result);
                    };

                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#defaultImageInput, #defaultImageShopInput").change(function() {
                readURL(this);
            });

            $('.setDefaultImage').on('click', function (evt) {
                evt.preventDefault();
                let input = $(this).data('input')
                $("#"+input).click();
            })


            $('.removeProductImage').on('click', function (e){
                $(this).closest('.ProductImage').hide('slow', function() {this.remove();});
            })

            $('.priceAfterDiscount').on('change', function() {
                let discount = $(this).val();
                let price = $('.price').val();
                if(parseFloat(discount) >= parseFloat(price)) {
                    $(this).notify('<?php echo app('translator')->get('global.price_must_lower_then'); ?>');
                    $(this).val('');
                }
            })
        });

        $(document).on('click', '.del_button', function (e) {
            e.preventDefault();
            var id = $(this).data('id');
            var image_id = $(this).data('image');

            Swal.fire({
                title: '<?php echo app('translator')->get('global.are_you_sure'); ?>',
                text: '<?php echo app('translator')->get('global.no_back'); ?>',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                cancelButtonText: '<?php echo app('translator')->get('global.cancel'); ?>',
                confirmButtonText: '<?php echo app('translator')->get('global.yes_deleted'); ?>'
                }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "<?php echo e(route('delete_product_image')); ?>",
                        type: "DELETE",
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>",
                            id: id,
                            image_id: image_id,
                        },
                        success: function (response) {

                            if(response.status==true) {
                                Swal.fire({
                                    icon: 'success',
                                    text: '<?php echo app('translator')->get('global.deleted_successful'); ?>',
                                    confirmButtonText: '<?php echo app('translator')->get('global.ok'); ?>',
                                }).then((res) => {
                                    if (res.isConfirmed) {
                                        location.reload();
                                    }
                                });
                            }
                            else {
                                Swal.fire({
                                    icon: 'warning',
                                    text: '<?php echo app('translator')->get('global.At_least_one_image_is_needed'); ?>',
                                    confirmButtonText: '<?php echo app('translator')->get('global.ok'); ?>',
                                }).then((res) => {
                                    if (res.isConfirmed) {
                                        location.reload();
                                    }
                                });
                            }
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/users-management/products/edit.blade.php ENDPATH**/ ?>