<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="rtl">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="Blockat">
    <meta name="keywords" content="Blockat">
    <meta name="author" content="Blockat">
    <title><?php echo app('translator')->get('global.blockat'); ?></title>
    <link rel="apple-touch-icon" href="<?php echo e(asset('/dashboard/images/ico/apple-icon-120.png')); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('/dashboard/images/ico/favicon.ico')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600" rel="stylesheet">

    <!-- BEGIN: Vendor CSS-->
    <?php if(in_array(app()->getLocale(), ['ar'])): ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/vendors/css/vendors-rtl.min.css")); ?>">
    <?php else: ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/vendors/css/vendors.min.css")); ?>">
    <?php endif; ?>

    <?php if(in_array(app()->getLocale(), ['ar'])): ?>
        <!-- BEGIN: Theme CSS-->
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/bootstrap.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/bootstrap-extended.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/colors.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/components.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/themes/dark-layout.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/themes/semi-dark-layout.css")); ?>">
        <link rel="stylesheet" type="text/css"
              href="<?php echo e(asset("dashboard/css-rtl/core/menu/menu-types/vertical-menu.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/core/colors/palette-gradient.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/pages/dashboard-analytics.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css-rtl/pages/card-analytics.css")); ?>">
        <link rel="stylesheet" type="text/css"
              href="<?php echo e(asset('dashboard/css-rtl/plugins/forms/validation/form-validation.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/custom.css")); ?>">
        <link rel="stylesheet" type="text/css"
              href="<?php echo e(asset('dashboard/css-rtl/plugins/file-uploaders/dropzone.css')); ?>">
        <?php echo $__env->yieldPushContent('style_rtl'); ?>
    <?php else: ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/bootstrap.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/bootstrap-extended.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/colors.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/components.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/themes/dark-layout.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/themes/semi-dark-layout.css")); ?>">

        <link rel="stylesheet" type="text/css"
              href="<?php echo e(asset("dashboard/css/core/menu/menu-types/vertical-menu.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/core/colors/palette-gradient.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/pages/dashboard-analytics.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/pages/card-analytics.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/custom.css")); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/css/plugins/file-uploaders/dropzone.css')); ?>">
        <?php echo $__env->yieldPushContent('style_ltr'); ?>
    <?php endif; ?>
    <link rel="stylesheet" typeof="text/css" href="<?php echo e(asset('dashboard/css/auction-status.css')); ?>">
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/js/scripts/datetimepicker/build/jquery.datetimepicker.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/js/scripts/jquery-magnific-popup/magnific-popup.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/fontawesome/css/all.css')); ?>"/>
    <?php echo $__env->yieldPushContent('style'); ?>
    <?php echo $__env->yieldPushContent('headerScript'); ?>
</head>
<!-- END: Head-->

<!-- BEGIN: Body-->
<body class="vertical-layout vertical-menu-modern semi-dark-layout 2-columns  navbar-floating footer-static  "
      data-open="click" data-menu="vertical-menu-modern" data-col="2-columns" data-layout="semi-dark-layout">
<!-- BEGIN: Header-->
<?php echo $__env->make('dashboard.layout.partials._header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- END: Header-->


<!-- BEGIN: Main Menu-->
<?php echo $__env->make('dashboard.layout.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- END: Main Menu-->

<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <?php echo $__env->yieldContent('breadcrumbs'); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>
</div>
<!-- END: Content-->

<div class="sidenav-overlay"></div>
<div class="drag-target"></div>

<!-- BEGIN: Footer-->
<footer class="footer footer-static footer-light">
    <p class="clearfix blue-grey lighten-2 mb-0"><span class="float-md-left d-block d-md-inline-block mt-25">COPYRIGHT &copy; <?php echo e(now()->year); ?>

            
            All rights Reserved</span>
        <span class="float-md-right d-none d-md-block">Hand-crafted & Made with<i
                class="feather icon-heart pink"></i></span>
        <button class="btn btn-primary btn-icon scroll-top" type="button"><i class="feather icon-arrow-up"></i></button>
    </p>
</footer>
<!-- END: Footer-->


<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(asset('/dashboard/vendors/js/vendors.min.js')); ?>"></script>
<!-- BEGIN Vendor JS-->

<!-- BEGIN: Page Vendor JS-->
<script src="<?php echo e(asset('/dashboard/vendors/js/charts/apexcharts.min.js')); ?>"></script>
<script src="<?php echo e(asset('/dashboard/vendors/js/extensions/tether.min.js')); ?>"></script>
<script src="<?php echo e(asset('/dashboard/vendors/js/extensions/shepherd.min.js')); ?>"></script>
<!-- END: Page Vendor JS-->

<!-- BEGIN: Theme JS-->
<script src="<?php echo e(asset('/dashboard/js/core/app-menu.js')); ?>"></script>
<script src="<?php echo e(asset('/dashboard/js/core/app.js')); ?>"></script>
<script src="<?php echo e(asset('/dashboard/js/scripts/components.js')); ?>"></script>
<script src="<?php echo e(asset("dashboard/js/scripts/notify.min.js")); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/2.0.2/anime.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script src="<?php echo e(asset("dashboard/js/scripts/jquery.toast.js")); ?>"></script>
<script src="<?php echo e(asset("dashboard/js/scripts/sortable.min.js")); ?>"></script>
<script src="<?php echo e(asset('dashboard/js/scripts/datetimepicker/build/jquery.datetimepicker.full.js')); ?>"></script>

<script src="https://cdn.jsdelivr.net/npm/jquery-sortablejs@latest/jquery-sortable.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
<script src="<?php echo e(asset('assets/js/jquery.animateCSS.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/js/scripts/jquery-magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/js/popper.min.js')); ?>"></script>
<script type="text/javascript"
        src="https://cdn.jsdelivr.net/npm/browser-image-compression@1.0.13/dist/browser-image-compression.js"></script>

<!-- END: Theme JS-->

<?php echo $__env->yieldPushContent('scripts'); ?>
<script>
    $(function () {
        let dir = "<?php echo e(getDir()); ?>";
        $('.form').on('submit', function () {
            $(this).find('button[type="submit"]').attr('disabled', true);
            $('.saveBtn').attr('disabled', true);
        });

        $('.citySelect').select2({
            dir: dir,
        });

        $('.select2Filter').select2({
            dir: dir,
        });

        $('[data-toggle="tooltip"]').tooltip()

        let body = $('body');
        let sessionErrors = JSON.parse("<?php echo e($errors); ?>".replace(/&quot;/g, '"'));
        let success = parseInt("<?php echo e(session()->has('success')); ?>");
        let error = parseInt("<?php echo e(session()->has('error')); ?>");

        $.each(sessionErrors, function (key, value) {
            console.log(key, value);
            $("[name='" + key + "']").notify(value[0], 'error');
        })

        if (success) {
            setTimeout(() => {
                Swal.fire({
                    icon: 'success',
                    title: "<?php echo e(session()->get('success')); ?>",
                    animation: false,
                    customClass: 'animated swing',
                    showLoaderOnConfirm: true,
                    onClose: function () {
                        return delaySwalWithAnimation("fadeInUp", "fadeOutUp");
                    },
                    preConfirm: function () {
                        return delaySwalWithAnimation("fadeInUp", "fadeOutUp");
                    }
                })
            }, 300)
        }

        if (error) {
            setTimeout(() => {
                Swal.fire({
                    icon: 'error',
                    title: "<?php echo e(session()->get('error')); ?>",
                    confirmButtonText: "<?php echo app('translator')->get('global.close'); ?>",
                    customClass: 'animated swing',
                    showLoaderOnConfirm: true,
                    onClose: function () {
                        return delaySwalWithAnimation("fadeInUp", "fadeOutUp");
                    },
                    preConfirm: function () {
                        return delaySwalWithAnimation("fadeInUp", "fadeOutUp");
                    }
                })
            }, 300)

        }

        $('.mpImage').magnificPopup({type: 'image'});

        body.on('click', '.deleteBtn', function (e) {
            e.preventDefault();
            let form = $(this).parents('form');
            let message = typeof $(this).data('message') !== 'undefined' ? $(this).data('message') : "<?php echo app('translator')->get('global.cannot_recovery'); ?>"
            Swal.fire({
                title: "<?php echo app('translator')->get('global.are_you_sure'); ?>",
                text: message,
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "<?php echo app('translator')->get('global.yes_deleted'); ?>",
                cancelButtonText: "<?php echo app('translator')->get('global.no_cancel'); ?>",
            }).then((result) => {
                if (result.value) {
                    form.submit();
                }
            })
        });

        body.on('click', '.deleteBtnRsn', function (e) {
            e.preventDefault();
            let form = $(this).parents('form');
            let message = typeof $(this).data('message') !== 'undefined' ? $(this).data('message') : "<?php echo app('translator')->get('global.cannot_recovery'); ?>"
            Swal.fire({
                title: "<?php echo app('translator')->get('global.are_you_sure'); ?>",
                text: message,
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "<?php echo app('translator')->get('global.yes_message'); ?>",
                cancelButtonText: "<?php echo app('translator')->get('global.no_cancel'); ?>",
            }).then(async (result) => {
                if (result.value) {
                    const {value: reason, isConfirmed} = await Swal.fire({
                        // input: 'textarea',
                        html: '<textarea class="swal2-textarea" id="reason" name="reason" placeholder="<?php echo e(__('Enter delete message (ar)')); ?>" style="display: flex;"></textarea><textarea id="reason_en" name="reason_en" class="swal2-textarea" placeholder="<?php echo e(__('Enter delete message (en)')); ?>" style="display: flex;"></textarea>',
                        title: "<?php echo app('translator')->get('global.delete_rsn_title'); ?>",
                        inputPlaceholder: "<?php echo app('translator')->get('global.delete_rsn_placeholder'); ?>",
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "<?php echo app('translator')->get('global.yes_deleted'); ?>",
                        showCancelButton: false,
                        showCloseButton: true,
                        preConfirm: () => {
                            return [document.getElementById('reason').value, document.getElementById('reason_en').value]
                        }
                        // allowOutsideClick: false,
                    })
                    if (isConfirmed) {
                        form.append(`<input type="hidden" name="reason" value="${reason[0]}"><input type="hidden" name="reason_ar" value="${reason[1]}">`);
                        form.submit();
                    }
                }


                // const {value: formValues} = await Swal.fire({
                //     title: 'Multiple inputs',
                //     html: '<input id="swal-input1" class="swal2-input">' + '<input id="swal-input2" class="swal2-input">',
                //     focusConfirm: false,
                //     preConfirm: () => {
                //         return [document.getElementById('swal-input1').value, document.getElementById('swal-input2').value]
                //     }
                // })
                if (formValues) {
                    Swal.fire(JSON.stringify(formValues))
                }


            })
        });

        body.on('click', '.restoreBtn', function (e) {
            e.preventDefault();
            let form = $(this).parents('form');
            Swal.fire({
                title: "<?php echo app('translator')->get('global.are_you_sure'); ?>",
                text: "<?php echo app('translator')->get('global.restore_data'); ?>",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "<?php echo app('translator')->get('global.yes_restore'); ?>",
                cancelButtonText: "<?php echo app('translator')->get('global.no_cancel'); ?>",
            }).then((result) => {
                if (result.value) {
                    form.submit();
                }
            })
        });

        $('.toggleIsApprove').on('click', function (evt) {
            evt.preventDefault();
            let type = $(this).data('type');
            let id = $(this).data('id');
            let route = $(this).data('route');
            let message = $(this).data('message');
            let altMsg = $(this).data('alt-msg');
            if (type == 'disappove') {
                $('#disapproveModal').modal('show');

                $("#btn-submit-comment").click(function () {
                    var comment = $('#comment').val();
                    var comment_en = $('#comment_en').val();
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(route('disapprove')); ?>",
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>",
                            id: id,
                            comment: comment,
                            type: type,
                            comment_en: comment_en
                        },
                        success: function (response) {
                            if (response.status == true) {
                                $('#disapproveModal').modal('hide');
                                $.Toast.showToast({
                                    "title": "Product declined successfully",
                                    "icon": "success",
                                    "duration": 1500,
                                });

                                window.location.reload();

                            } else {
                                swal.fire(
                                    'Error!',
                                    response.message,
                                    'error'
                                )
                            }
                        },
                        error: function () {
                            swal.fire(
                                'Error!',
                                'Sorry! Something went wrong',
                                'error'
                            )
                        }
                    });
                });

            } else {
                Swal.fire({
                    title: "<?php echo app('translator')->get('global.are_you_sure'); ?>",
                    text: message,
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "<?php echo app('translator')->get('global.yes_toggle_it'); ?>",
                    cancelButtonText: "<?php echo app('translator')->get('global.no_cancel'); ?>",
                }).then((result) => {
                    if (result.value) {
                        $.Toast.showToast({
                            "title": "<?php echo app('translator')->get('global.wait_to_proceed'); ?>",
                            "icon": "loading",
                            "duration": -1,
                        });

                        $.ajax({
                            method: "post",
                            url: route,
                            data: {_token: "<?php echo e(csrf_token()); ?>", id: id},
                            success: (response) => {
                                $.Toast.hideToast();
                                $.Toast.showToast({
                                    "title": "<?php echo app('translator')->get('global.toggle_done'); ?>",
                                    "icon": "success",
                                    "duration": 1500,
                                });
                                if (response.is_approved) {
                                    $(this).removeClass('btn-success');
                                    $(this).addClass('btn-dark');
                                    $(this).find('i').removeClass('fa-eye');
                                    $(this).find('i').addClass('fa-eye-slash');
                                    let i = $(this).closest('tr').find('.is_approved').find('i');
                                    i.removeClass('fa-times text-danger');
                                    i.addClass('fa-check text-success');

                                } else {
                                    $(this).removeClass('btn-dark');
                                    $(this).addClass('btn-success');
                                    $(this).find('i').removeClass('fa-eye-slash');
                                    $(this).find('i').addClass('fa-eye');
                                    let i = $(this).closest('tr').find('.is_approved').find('i');
                                    i.addClass('fa-times text-danger');
                                    i.removeClass('fa-check text-success');
                                }
                                $(this).data('message', altMsg);
                                $(this).data('alt-msg', message);
                                window.location.reload();
                            },
                            error: (response) => {
                                $.Toast.hideToast();
                                $.Toast.showToast({
                                    "title": "<?php echo app('translator')->get('global.failed_to_toggle'); ?>",
                                    "icon": "error",
                                    "duration": 3000,
                                });
                            }
                        })
                    }
                })
            }
        });

        $('.toggleIsActive').on('click', function (evt) {
            evt.preventDefault();
            let id = $(this).data('id');
            let route = $(this).data('route');
            let message = $(this).data('message');
            let altMsg = $(this).data('alt-msg');
            Swal.fire({
                title: "<?php echo app('translator')->get('global.are_you_sure'); ?>",
                text: message,
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "<?php echo app('translator')->get('global.yes_toggle_it'); ?>",
                cancelButtonText: "<?php echo app('translator')->get('global.no_cancel'); ?>",
            }).then((result) => {
                if (result.value) {
                    $.Toast.showToast({
                        "title": "<?php echo app('translator')->get('global.wait_to_proceed'); ?>",
                        "icon": "loading",
                        "duration": -1,
                    });

                    $.ajax({
                        method: "post",
                        url: route,
                        data: {_token: "<?php echo e(csrf_token()); ?>", id: id},
                        success: (response) => {
                            $.Toast.hideToast();
                            $.Toast.showToast({
                                "title": "<?php echo app('translator')->get('global.toggle_done'); ?>",
                                "icon": "success",
                                "duration": 1500,
                            });
                            if (response.is_active) {
                                $(this).removeClass('btn-success');
                                $(this).addClass('btn-dark');
                                $(this).find('i').removeClass('fa-thumbs-up');
                                $(this).find('i').addClass('fa-thumbs-down');
                                let i = $(this).closest('tr').find('.is_active').find('i');
                                i.removeClass('fa-times text-danger');
                                i.addClass('fa-check text-success');

                            } else {
                                $(this).removeClass('btn-dark');
                                $(this).addClass('btn-success');
                                $(this).find('i').removeClass('fa-thumbs-down');
                                $(this).find('i').addClass('fa-thumbs-up');
                                let i = $(this).closest('tr').find('.is_active').find('i');
                                i.addClass('fa-times text-danger');
                                i.removeClass('fa-check text-success');
                            }
                            $(this).data('message', altMsg);
                            $(this).data('alt-msg', message);
                        },
                        error: (response) => {
                            $.Toast.hideToast();
                            $.Toast.showToast({
                                "title": "<?php echo app('translator')->get('global.failed_to_toggle'); ?>",
                                "icon": "error",
                                "duration": 3000,
                            });
                        }
                    })
                }
            })
        });

        // if ('serviceWorker' in navigator) {
        //     navigator.serviceWorker.register('/serviceworke.js', {
        //         scope: '/'
        //     });
        // }

        $('.readNotification').on('click', function (e) {
            e.preventDefault();
            e.stopPropagation();
            let id = $(this).data('id');
            Swal.fire({
                title: "<?php echo app('translator')->get('global.are_you_sure'); ?>",
                text: "<?php echo app('translator')->get('global.delete_notification'); ?>",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "<?php echo app('translator')->get('global.yes_deleted'); ?>",
                cancelButtonText: "<?php echo app('translator')->get('global.no_cancel'); ?>",
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        method: "post",
                        url: "",
                        data: {_token: "<?php echo e(csrf_token()); ?>", id: id},
                        success: (response) => {
                            $(this).closest('.notificationContainer').remove();
                            $('.notiCount').html(response.count)
                        }
                    })
                }
            }).then(() => {
                setTimeout(() => {
                    $('.uiNotification').dropdown('show');
                }, 400)
            })
        });

        $('body input[type="file"]').on('change', function (e) {
            var pageURL = window.location.href;
            var lastURLSegment = pageURL.split('/');
            if (lastURLSegment[4] !== 'categories') {
                handleImageUpload(e);
            }
        });

        function delaySwalWithAnimation(animationA, animationB) {
            return new Promise(function (resolve) {
                $(".swal2-popup").removeClass(animationA);
                $(".swal2-popup").addClass(animationB);
                setTimeout(function () {
                    resolve();
                }, 300);
            });
        }

        async function handleImageUpload(event) {
            let container = new DataTransfer();
            let images = Array.from(event.target.files)

            for (const imageFile of images) {
                // console.log('originalFile instanceof Blob', imageFile instanceof Blob); // true
                // console.log(`originalFile size ${imageFile.size / 1024 / 1024} MB`);

                const options = {
                    maxSizeMB: 1,
                    maxWidthOrHeight: 1920,
                    useWebWorker: true
                }
                try {
                    const compressedFile = await imageCompression(imageFile, options);
                    // console.log('compressedFile instanceof Blob', compressedFile instanceof Blob); // true
                    // console.log(`compressedFile size ${compressedFile.size / 1024 / 1024} MB`); // smaller than maxSizeMB

                    let file = new File([compressedFile], compressedFile.name)
                    container.items.add(file);
                } catch (error) {
                    console.log(error);
                }
            }

            event.target.files = container.files
        }

    })

</script>
</body>
<!-- END: Body-->

</html>
<?php /**PATH /var/www/html/Blockat/resources/views/dashboard/layout/main.blade.php ENDPATH**/ ?>