<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.shops'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.users_management'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('shops.index')); ?>"><?php echo app('translator')->get('sidebar.shops'); ?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo app('translator')->get('global.create'); ?>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <?php if($errors->any()): ?>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div><?php echo e($error); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <form class="form" action="<?php echo e(route('shops.store')); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="custom-hr"><span> <?php echo app('translator')->get('global.manager_information'); ?></span></div>
                                    <div class="row">
                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.name'); ?></label>
                                                    <input type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('global.name'); ?>" value="<?php echo e(old('name')); ?>">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.country'); ?></label>
                                                    <select class="form-control" name="country_id" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="" <?php echo e(is_null(old('country_id')) == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.select_country'); ?></option>
                                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($country->id); ?>" <?php echo e(old('country_id') == $country->id ? "selected" : ""); ?>>
                                                                <?php echo e($country->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <fieldset class="form-group position-relative input-divider-right">
                                                <label><?php echo app('translator')->get('global.phone'); ?></label>
                                                <input type="text"
                                                       class="form-control"
                                                       name="phone"
                                                       placeholder="<?php echo app('translator')->get('global.phone_pattern'); ?>"
                                                       value="<?php echo e(old('phone')); ?>"
                                                       autocomplete="off"
                                                       required="">
                                            </fieldset>
                                        </div>

                                        

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.active_status'); ?></label>
                                                    <select class="form-control" name="is_active" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="" <?php echo e(is_null(old('is_active')) == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.select_is_active'); ?></option>
                                                        <option value="1" <?php echo e(old('is_active') == 1 ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                                        <option value="0" <?php echo e(!is_null(old('is_active')) && old('is_active') == 0 ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.language'); ?></label>
                                                    <select class="form-control" name="lang" required="" data-validation-required-message="<?php echo app('translator')->get('global.this_filed_required'); ?>">
                                                        <option value="" <?php echo e(is_null(old('lang')) ? "selected" : ""); ?>><?php echo app('translator')->get('global.select_language'); ?></option>
                                                        <option value="ar" <?php echo e(old('lang') == 'ar' ? "selected" : ""); ?>><?php echo app('translator')->get('global.arabic'); ?></option>
                                                        <option value="en" <?php echo e(!is_null(old('lang')) && old('lang') == 'en' ? "selected" : ""); ?>><?php echo app('translator')->get('global.english'); ?></option>
                                                    </select>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        

                                    </div>
                                    <div class="custom-hr"><span> <?php echo app('translator')->get('global.shop_information'); ?></span></div>
                                    <div class="col-12 text-center mb-1 imageDiv">
                                        <input type="file" style="display: none" name="shop_image" id="defaultImageShopInput">
                                        <img src="<?php echo e(asset('dashboard/images/logo/shop.png')); ?>" class="img-fluid mb-1 rounded-sm defaultShopImage" style="width: 100px" alt="user_image">
                                        <br>
                                        <button type="button" class="btn btn-primary btn-sm setDefaultImage" data-input="defaultImageShopInput"><?php echo app('translator')->get('global.change_shop_image'); ?></button>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.shop_name'); ?></label>
                                                    <input type="text" class="form-control" name="shop_name" placeholder="<?php echo app('translator')->get('global.shop_name'); ?>" value="<?php echo e(old('shop_name')); ?>">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.shop_name_en'); ?></label>
                                                    <input type="text" class="form-control" name="shop_name_en" placeholder="<?php echo app('translator')->get('global.shop_name_en'); ?>" value="<?php echo e(old('shop_name_en')); ?>">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                        <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.whatsapp'); ?></label>
                                                    <input type="text" class="form-control" name="whatsapp" placeholder="<?php echo app('translator')->get('global.whatsapp'); ?>" value="<?php echo e(old('whatsapp')); ?>">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.instagram'); ?></label>
                                                    <input type="text" class="form-control arShopDescription" name="instagram" placeholder="<?php echo app('translator')->get('global.instagram'); ?>" value="<?php echo e(old('instagram')); ?>">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.facebook'); ?></label>
                                                    <input type="text" class="form-control" name="facebook" placeholder="<?php echo app('translator')->get('global.facebook'); ?>" value="<?php echo e(old('facebook')); ?>" >
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                            <div class="col-md-6 col-6">
                                                <div class="form-group">
                                                    <div class="controls">
                                                        <label><?php echo app('translator')->get('global.snapchat'); ?></label>
                                                        <input type="text" class="form-control" name="snapchat" placeholder="<?php echo app('translator')->get('global.snapchat'); ?>" value="<?php echo e(old('snapchat')); ?>" >
                                                        <div class="help-block"></div>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="<?php echo e(route('shops.index')); ?>" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .custom-hr{
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 30px 0;
        }
        .custom-hr > span{
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(function (){
            setTimeout(() => {
                $('.shopIsSpecial').trigger('change');
            }, 900);

            $('.shopIsSpecial').on('change', function (evt){
                if($(this).find('option:selected').val() == 1) {
                    $('.specialImageDiv').removeClass('d-none');
                    $('.specialToDiv').removeClass('d-none');
                    $('.specialImageInput').prop('required', true);
                    $('.specialToInput').prop('required', true);
                    $('.arShopName').prop('required', true);
                    $('.arShopDescription').prop('required', true);
                }  else {
                    $('.specialImageDiv').addClass(' d-none');
                    $('.specialToDiv').addClass(' d-none');
                    $('.specialImageInput').prop('required', false);
                    $('.specialToInput').prop('required', false);
                    $('.arShopName').prop('required', false);
                    $('.arShopDescription').prop('required', false);
                }
            });

            $('.specialToInput').datetimepicker({
                minDate: 0,
                timepicker:false,
                format:'Y/m/d'
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $(input).closest('.imageDiv').find('img').attr('src', e.target.result);
                    };

                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#defaultImageInput, #defaultImageShopInput").change(function() {
                readURL(this);
            });

            $('.setDefaultImage').on('click', function (evt) {
                evt.preventDefault();
                let input = $(this).data('input')
                $("#"+input).click();
            })
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/users-management/shops/create.blade.php ENDPATH**/ ?>