<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.notifications'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.notifications'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="<?php echo e(route('notifications.store')); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php if(!empty($data)): ?>
                                    <div class="col-12 text-center mb-1 imageDiv">
                                        <a href="<?php echo e($data['image']); ?>" class="mpImage">
                                            <img src="<?php echo e($data['image']); ?>"
                                                 class="img-fluid mb-1 rounded-sm defaultShopImage" style="width: 100px"
                                                 alt="user_image">
                                        </a>
                                        <br>
                                        <h4><?php echo e($data['name']); ?></h4>
                                    </div>
                                    <input type="hidden" value="<?php echo e($data['image']); ?>" name="itemImage">
                                    <input type="hidden" value="<?php echo e($data['id']); ?>" name="itemId">
                                    <input type="hidden" value="<?php echo e(request()->input('type')); ?>" name="itemType">
                                <?php endif; ?>
                                <div class="custom-hr"><span> <?php echo app('translator')->get('global.select_user_to_send_notification'); ?></span>
                                </div>
                                <div class="row">
                                    <div class="col-12 pr30px">
                                        <select class="form-control select2Filter usersSelect" name="users_type"
                                                required>
                                            <option value=""> <?php echo app('translator')->get('global.select_user'); ?></option>
                                            <option
                                                value="0" <?php echo e((old('users_type') == '0' ? 'selected' : '')); ?>> <?php echo app('translator')->get('global.all_users'); ?></option>
                                            <option
                                                value="1" <?php echo e((old('users_type') == '1' ? 'selected' : '')); ?>> <?php echo app('translator')->get('global.normal_users'); ?></option>
                                            <option
                                                value="2" <?php echo e((old('users_type') == '2' ? 'selected' : '')); ?>> <?php echo app('translator')->get('global.shop_users'); ?></option>

                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 mt-2">
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.notification_title_ar'); ?></label>
                                                    <input name="title" class="form-control" value="<?php echo e(old('title')); ?>"
                                                           required>
                                                    <small><?php echo app('translator')->get('global.max_100'); ?></small>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.notification_title_en'); ?></label>
                                                    <input name="title_en" class="form-control" value="<?php echo e(old('title')); ?>"
                                                           required>
                                                    <small><?php echo app('translator')->get('global.max_100'); ?></small>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(empty($data)): ?>
                                            <div class="col-md-6 col-6">
                                                <div class="form-group">
                                                    <div class="controls">
                                                        <label><?php echo app('translator')->get('global.notification_image'); ?></label>
                                                        <input type="file" name="image" class="form-control"
                                                               value="<?php echo e(old('image')); ?>">
                                                        <div class="help-block"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <label><?php echo app('translator')->get('global.notification_body_ar'); ?></label>
                                                <textarea cols="12" rows="6" name="body" class="form-control"
                                                          required><?php echo e(old('body')); ?></textarea>
                                                <small><?php echo app('translator')->get('global.max_length'); ?><span
                                                        id="bodyLength">1000</span></small>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <label><?php echo app('translator')->get('global.notification_body_en'); ?></label>
                                                <textarea cols="12" rows="6" name="body_en" class="form-control"
                                                          required><?php echo e(old('body')); ?></textarea>
                                                <small><?php echo app('translator')->get('global.max_length'); ?><span
                                                        id="bodyLength">1000</span></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('notifications_index')): ?>
                                    <div class="col-12 d-flex flex-sm-row flex-column justify-content-center mt-1">
                                        <button type="submit"
                                                class="btn btn-primary glow mb-1 mb-sm-0 mr-0 mr-sm-1"><?php echo app('translator')->get('global.send'); ?></button>
                                    </div>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Nav Justified Ends -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset("dashboard/css/pages/app-user.min.css")); ?>">
    <style>
        .custom-hr {
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 30px 0;
        }

        .custom-hr > span {
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }

        .userActive {
            background-color: #38347a !important;
        }

        .pr30px {
            padding-right: 30px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(function () {
            let dir = "<?php echo e(getDir()); ?>";
            $('#replayType').on('change', function () {
                $('#bodyLength').html(2048);
            })

            $('.sendToAllCheckBox').on('click', function () {
                $('.select2Filter').val(null).trigger("change");
            })

            $('.select2Filter').on('select2:select', function () {
                $('.sendToAllCheckBox').prop('checked', false);
            })

        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/complaints_management/notifications/index.blade.php ENDPATH**/ ?>