<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.admins'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('roles.index')); ?>"><?php echo app('translator')->get('sidebar.roles'); ?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo app('translator')->get('global.edit'); ?>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="<?php echo e(route('roles.update', $role->id)); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.en_name'); ?></label>
                                                    <input autocomplete="off" type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('global.name'); ?>" value="<?php echo e(old('name', $role->name)); ?>" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.ar_name'); ?></label>
                                                    <input autocomplete="off" type="text" class="form-control" name="ar_name" placeholder="<?php echo app('translator')->get('global.ar_name'); ?>" value="<?php echo e(old('ar_name', $role->ar_name)); ?>" required>
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="custom-hr"><span> <?php echo app('translator')->get('global.permissions'); ?></span></div>

                                        <div class="col-md-12 col-12">
                                            <div class="card collapse-icon accordion-icon-rotate">
                                                <div class="card-body">
                                                    <div class="accordion" id="accordionExample" data-toggle-hover="true">
                                                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permissions_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="collapse-margin">
                                                                <div class="card-header collapsed bg-primary text-white" id="heading<?php echo e($loop->iteration); ?>" data-toggle="collapse" role="button" data-target="#collapse<?php echo e($loop->iteration); ?>" aria-expanded="false" aria-controls="collapse<?php echo e($loop->iteration); ?>">
                                                                    <span class="lead collapse-title">
                                                                        <?php echo e(getRoleName($permissions_group->first())); ?>

                                                                    </span>
                                                                    <div class="header-selectable">
                                                                        <button type="button" class="btn btn-sm btn-dark selectAll"><?php echo app('translator')->get('global.select_all'); ?></button>
                                                                        <button type="button" class="btn btn-sm btn-danger deselectAll"><?php echo app('translator')->get('global.deselect_all'); ?></button>
                                                                    </div>
                                                                </div>

                                                                <div id="collapse<?php echo e($loop->iteration); ?>" class="collapse" aria-labelledby="heading<?php echo e($loop->iteration); ?>" data-parent="#accordionExample">
                                                                    <div class="card-body">
                                                                        <div class="row">
                                                                            <?php $__currentLoopData = $permissions_group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div class="col-3">
                                                                                    <fieldset>
                                                                                        <div class="vs-checkbox-con vs-checkbox-primary">
                                                                                            <input
                                                                                                type="checkbox"
                                                                                                value="<?php echo e($permission->id); ?>"
                                                                                                name="permissions[<?php echo e($permission->id); ?>]"
                                                                                                class="p<?php echo e($loop->iteration); ?>

                                                                                                <?php echo e($loop->iteration != 1 ? "selectIndex" : ""); ?>"
                                                                                                <?php echo e(in_array($permission->name, $rolePermissions) ? "checked" : ''); ?>

                                                                                            >
                                                                                            <span class="vs-checkbox vs-checkbox-lg">
                                                                                                                <span class="vs-checkbox--check">
                                                                                                                    <i class="vs-icon feather icon-check"></i>
                                                                                                                </span>
                                                                                                            </span>
                                                                                            <span class=""><?php echo e(getRoleName($permission)); ?></span>
                                                                                        </div>
                                                                                    </fieldset>
                                                                                </div>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ</button>
                                    <a href="<?php echo e(route('roles.index')); ?>" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .header-selectable{
            margin-left: 50px;
        }
        .collapse-margin {
            box-shadow: 0 2px 15px 0 #150101b5;
            text-align: center;
        }
        .custom-hr{
            width: 100%;
            height: 20px;
            border-bottom: 1px solid #5BA72C;
            text-align: center;
            margin: 15px 0;
        }
        .custom-hr > span{
            font-size: 25px;
            background-color: #ffffff;
            padding: 0 20px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(function() {
            $('.selectAll').click(function (evt){
                evt.stopPropagation();
                $(this).closest('.collapse-margin').find('input[type="checkbox"]').prop('checked', true);
            })

            $('.deselectAll').click(function (evt){
                evt.stopPropagation();
                $(this).closest('.collapse-margin').find('input[type="checkbox"]').prop('checked', false);
            })

            $('.selectIndex').on('click', function (evt){
                $(this).closest('.row').find('.p1').prop('checked', true);
            });

            $('.p1').on('click', function (){
                if(!$(this).is(':checked')) {
                    $(this).closest('.row').find('input[type="checkbox"]').prop('checked', false);
                }
            })

        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/administrator/roles/edit.blade.php ENDPATH**/ ?>